% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.statespacer}
\alias{predict.statespacer}
\title{State Space Model Forecasting}
\usage{
\method{predict}{statespacer}(
  object,
  addvar_list_fc = NULL,
  level_addvar_list_fc = NULL,
  self_spec_list_fc = NULL,
  forecast_period = 1,
  ...
)
}
\arguments{
\item{object}{A statespacer object as returned by \code{\link{statespacer}}.}

\item{addvar_list_fc}{A list containing the explanatory variables for each
of the dependent variables. The list should contain p (number of dependent
variables) elements. Each element of the list should be a
\code{forecast_period} x k_p matrix, with k_p being the number of explanatory
variables for the pth dependent variable. If no explanatory variables
should be added for one of the dependent variables, then set the
corresponding element to \code{NULL}.}

\item{level_addvar_list_fc}{A list containing the explanatory variables
for each of the dependent variables. The list should contain p
(number of dependent variables) elements. Each element of the list should
be a \code{forecast_period} x k_p matrix, with k_p being the number of
explanatory variables for the pth dependent variable. If no explanatory
variables should be added for one of the dependent variables, then set
the corresponding element to \code{NULL}.}

\item{self_spec_list_fc}{A list containing the specification of the self
specified component. Does not have to be specified if it does not differ
from \code{self_spec_list} as passed on to \code{\link{statespacer}}. If some
system matrices are time-varying then you should specify this argument.
See \code{\link{statespacer}} for details about the format that must be
followed for this argument.}

\item{forecast_period}{Number of time steps to forecast ahead.}

\item{...}{Arguments passed on to the \code{predict} generic. Should not be used!}
}
\value{
A list containing the forecasts and corresponding uncertainties.
In addition, it returns the components of the forecasts, as specified
by the State Space model.
}
\description{
Produces forecasts using a fitted State Space Model.
}
\examples{
# Fits a local level model for the Nile data
library(datasets)
y <- matrix(Nile)
fit <- statespacer(initial = 10, y = y, local_level_ind = TRUE)

# Obtain forecasts for 10 steps ahead using the fitted model
fc <- predict(fit, forecast_period = 10)

# Plot the forecasts
plot(1:10, fc$y_fc, type = "l")
}
\references{
\insertRef{durbin2012time}{statespacer}
}
\author{
Dylan Beijers, \email{dylanbeijers@gmail.com}
}
