% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_met_data.R
\name{get_met_data}
\alias{get_met_data}
\title{Get data from a meteorological station}
\usage{
get_met_data(station_id, years = NULL, full_data = FALSE,
  add_fields = NULL, make_hourly = TRUE, local_file_dir = NULL)
}
\arguments{
\item{station_id}{A station identifier composed of the station's USAF and
WBAN numbers, separated by a hyphen.}

\item{years}{The years for which station met data will be collected. If not
specified then all records for all available years will be obtained for the
station.}

\item{full_data}{Include all additional meteorological data found in the
dataset's additional data section?}

\item{add_fields}{A vector of categories for additional meteorological data
to include (instead of all available categories).}

\item{make_hourly}{Transforms data to force values to the start of each hour.
All data is bucketed by hour and all missing hours are filled with \code{NA}s.
This regularizes each year of data, where the number of records per year of
data will be either 8760 or 8784 (depending on whether a year is a leap
year). By default to this is \code{TRUE}.}

\item{local_file_dir}{Path to local meteorological data files. If specified,
then data files will be downloaded to and retrieved from this location and
not from the remote data store.}
}
\value{
Returns a tibble with at least 10 variables. While times are recorded
using the Universal Time Code (UTC) in the source data, they are adjusted
here to local standard time for the station's locale.
\describe{
\item{id}{A character string identifying the fixed weather station
from the USAF Master Station Catalog identifier and the WBAN identifier.}
\item{time}{A datetime value representing the observation time.}
\item{temp}{Air temperature measured in degrees Celsius. Conversions to
degrees Fahrenheit may be calculated with \code{(temp * 9) / 5 + 32}.}
\item{wd}{The angle of wind direction, measured in a clockwise direction,
between true north and the direction from which the wind is blowing. For
example, \code{wd = 90} indicates the wind is blowing from due east. \code{wd = 225}
indicates the wind is blowing from the south west. The minimum value is \code{1},
and the maximum value is \code{360}.}
\item{ws}{Wind speed in meters per second. Wind speed in feet per second can
be estimated by \code{ws * 3.28084}.}
\item{atmos_pres}{The air pressure in hectopascals relative to Mean Sea Level
(MSL).}
\item{dew_point}{The temperature in degrees Celsius to which a given parcel
of air must be cooled at constant pressure and water vapor content in order
for saturation to occur.}
\item{rh}{Relative humidity, measured as a percentage, as calculated using
the August-Roche-Magnus approximation.}
\item{ceil_hgt}{The height above ground level of the lowest cloud cover or
other obscuring phenomena amounting to at least 5/8 sky coverage. Measured in
meters. Unlimited height (no obstruction) is denoted by the value \code{22000}.}
\item{visibility}{The horizontal distance at which an object can be seen and
identified. Measured in meters. Values greater than \code{16000} are entered as
\code{16000} (which constitutes 10 mile visibility).}
}
}
\description{
Obtain one or more years of meteorological data for a particular station.
}
\examples{
\dontrun{
# Obtain two years of data from the
# met station with the ID value of
# "999999-63897" 
met_data <- 
  get_met_data(
    station_id = "999999-63897",
    years = 2013:2014
  )
}

}
