% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{sim.ci.cor}
\alias{sim.ci.cor}
\title{Simulates confidence interval coverage probability for a Pearson
correlation}
\usage{
sim.ci.cor(alpha, n, cor, dist1, dist2, rep)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{n}{sample size}

\item{cor}{population Pearson correlation}

\item{dist1}{type of distribution at level 1 (1, 2, 3, 4, or 5)}

\item{dist2}{type of distribution at level 2 (1, 2, 3, 4, or 5)
\itemize{
\item 1 = Gaussian (skewness = 0 and excess kurtosis = 0)
\item 2 = platykurtic (skewness = 0 and excess kurtosis = -1.2)
\item 3 = leptokurtic (skewness = 0 and excess kurtsois = 6)
\item 4 = moderate skew (skewness = 1 and excess kurtosis = 1.5)
\item 5 = large skew (skewness = 2 and excess kurtosis = 6)
}}

\item{rep}{number of Monte Carlo samples}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Coverage - probability of confidence interval including population mean
\item Lower Error - probability of lower limit greater than population mean
\item Upper Error - probability of upper limit less than population mean
\item Ave CI Width - average confidence interval width
}
}
\description{
Performs a computer simulation of confidence interval performance for a
Pearson correlation. A bias adjustment is used to reduce the bias of the
Fisher transformed Pearson correlation. Sample data can be generated
from bivariate population distributions with five different marginal
distributions. All distributions are scaled to have standard deviations
of 1.0. Bivariate random data with specified marginal skewness and
kurtosis are generated using the unonr function in the mnonr package.
}
\examples{
sim.ci.cor(.05, 30, .7, 4, 5, 1000)

# Should return (within sampling error):
#      Coverage Lower Error Upper Error Ave CI Width
# [1,]  0.93815     0.05125      0.0106    0.7778518


}
