% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.condslope}
\alias{ci.condslope}
\title{Confidence interval for conditional (simple) slopes in a linear model}
\usage{
ci.condslope(alpha, b1, b2, se1, se2, cov, lo, hi, dfe)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{b1}{estimated slope coefficient for predictor variable}

\item{b2}{estimated slope coefficient for product variable}

\item{se1}{standard error for predictor coefficient}

\item{se2}{standard error for product coefficient}

\item{cov}{estimated covariance between predictor and product coefficients}

\item{lo}{low value of moderator variable}

\item{hi}{high value of moderator variable}

\item{dfe}{error degrees of freedom}
}
\value{
Returns a 2-row matrix. The columns are:
\itemize{
\item Estimate - estimated condition slope
\item t - t test statistic
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes confidence intervals and test statistics for population
conditional slopes (simple slopes) in a general linear model that
includes a predictor variable that is the product of a moderator
variable and a predictor variable. Conditional slopes are computed
at specified low and high values of the moderator variable.
}
\examples{
ci.condslope(.05, .132, .154, .031, .021, .015, 5.2, 10.6, 122)

# Should return:
#                   Estimate        SE        t  df           p 
# At low moderator    0.9328 0.4109570 2.269824 122 0.024973618 
# At high moderator   1.7644 0.6070517 2.906507 122 0.004342076 
#                           LL       UL
# At low moderator   0.1192696 1.746330
# At high moderator  0.5626805 2.966119
 

}
