% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.ratio.prop.ps}
\alias{ci.ratio.prop.ps}
\title{Confidence interval for a paired-samples proportion ratio}
\usage{
ci.ratio.prop.ps(alpha, f00, f01, f10, f11)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f00}{number of participants with y = 0 and x = 0}

\item{f01}{number of participants with y = 0 and x = 1}

\item{f10}{number of participants with y = 1 and x = 0}

\item{f11}{number of participants with y = 1 and x = 1}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimate of proportion ratio
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a ratio of proportions in a
paired-samples design. This function requires the frequency counts from
a 2 x 2 contingency table for two repeated dichotomous measurements.
}
\examples{
ci.ratio.prop.ps(.05, 12, 4, 26, 6)

# Should return:
# Estimate       LL       UL
#      3.2 1.766544 5.796628


}
\references{
\insertRef{Bonett2006a}{statpsych}
}
