% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.prop.inv}
\alias{ci.prop.inv}
\title{Confidence interval for a proportion using inverse sampling}
\usage{
ci.prop.inv(alpha, f, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f}{number of participants who have the attribute (fixed)}

\item{n}{sample size (random)}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimate of proportion
\item SE - recovered standard error
\item LL - lower limit of confidence interval
\item UL - upper limit of confidence interval
}
}
\description{
Computes an exact confidence interval for a population proportion
when inverse sampling has been used. An approximate standard error is
recovered from the confidence interval. With inverse sampling, the number
of participants who have the attribute (f) is predetermined and sampling
continues until f attains its prespecified value. With inverse sampling,
the sample size (n) will not be known in advance.
}
\examples{
ci.prop.inv(.05, 5, 67)

# Should return:
#   Estimate         SE         LL        UL
# 0.07462687 0.03145284 0.02467471 0.1479676


}
\references{
\insertRef{Zou2010}{statpsych}
}
