% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{power.prop}
\alias{power.prop}
\title{Approximates the power of a 1-group proportion test for a planned sample
size}
\usage{
power.prop(alpha, n, p, es)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{n}{planned sample size}

\item{p}{planning value of proportion}

\item{es}{planning value of proportion minus null hypothesis value}
}
\value{
Returns the approximate power of the test
}
\description{
Computes the approximate power of a one-sample proportion test for a
planned sample size. Set the proportion planning value to .5 for a
conservatively low power estimate. The value of the effect size need
not be based on the proportion planning value.
}
\examples{
power.prop(.05, 40, .5, .2)

# Should return:
#     Power
# 0.7156044


}
