% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_meta_analysis_expressions.R
\name{expr_meta_robust}
\alias{expr_meta_robust}
\title{Making expression with frequentist random-effects robust meta-analysis
results}
\usage{
expr_meta_robust(data, random = "mixture", k = 2, messages = FALSE, ...)
}
\arguments{
\item{data}{A dataframe. It \strong{must} contain columns named \code{estimate} (effect
sizes or outcomes)  and \code{std.error} (corresponding standard errors). These
two columns will be used for \code{yi}  and \code{sei} arguments in \code{metafor::rma}
(for parametric analysis) or \code{metaplus::metaplus} (for robust analysis).}

\item{random}{
The type of random effects distribution. One of "normal","t-dist","mixture", for standard normal, \eqn{t}-distribution or mixture of normals respectively.
}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{...}{
  Arguments passed on to \code{\link[metaplus:metaplus]{metaplus::metaplus}}
  \describe{
    \item{\code{mods}}{
data frame of covariates corresponding to each study
}
    \item{\code{label}}{
The label to be used for this model when plotting
}
    \item{\code{plotci}}{
Should profile be plotted for each confidence interval?
}
    \item{\code{justfit}}{
Should model only be fitted? If justfit=TRUE then profiling and likelihood ratio statistics are not calculated. Useful for when bootstrapping.
}
    \item{\code{slab}}{
Vector of character strings corresponding to each study.
}
    \item{\code{useAGQ}}{
Use adaptive Gauss-Hermite quadrature when performing integration for t-distribution random-effects. Useful when standard errors for studies are relatively small.
}
    \item{\code{quadpoints}}{
Number of quadrature points to use in adaptive Gauss-Hermite quadrature.
}
  }}
}
\description{
This analysis is carried out using the \code{metaplus} package. For
more, see \code{?metaplus::metaplus}.
}
\examples{
\donttest{
# setup
set.seed(123)
library(metaplus)

# renaming to what `statsExpressions` expects
df <- dplyr::rename(mag, estimate = yi, std.error = sei)

# creating expression (changing few defaults)
expr_meta_robust(
  data = df,
  random = "normal",
  k = 4,
  messages = TRUE,
  plotci = TRUE
)
}
}
