% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_meta_analysis_expressions.R
\name{expr_meta_parametric}
\alias{expr_meta_parametric}
\title{Making expression with frequentist random-effects meta-analysis
results}
\usage{
expr_meta_parametric(
  data,
  conf.level = 0.95,
  k = 2,
  messages = FALSE,
  output = "subtitle",
  caption = NULL,
  ...
)
}
\arguments{
\item{data}{A dataframe. It \strong{must} contain columns named \code{estimate} (effect
sizes or outcomes)  and \code{std.error} (corresponding standard errors). These
two columns will be used for \code{yi}  and \code{sei} arguments in \code{metafor::rma}
(for parametric analysis) or \code{metaplus::metaplus} (for robust analysis).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{output}{Character describing the desired output. If \code{"subtitle"}, a
formatted subtitle with summary effect and statistical details will be
returned, and if \code{"caption"}, expression containing details from model
summary will be returned. The other option is to return \code{"tidy"} data frame
with coefficients or \code{"glance"} dataframe with model summaries.}

\item{caption}{Text to display as caption. This argument is relevant only
when \code{output = "caption"}.}

\item{...}{
  Arguments passed on to \code{\link[metafor:rma]{metafor::rma}}
  \describe{
    \item{\code{vi}}{vector of length \eqn{k} with the corresponding sampling variances. See \sQuote{Details}.}
    \item{\code{weights}}{optional argument to specify a vector of length \eqn{k} with user-defined weights. See \sQuote{Details}.}
    \item{\code{ai}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{bi}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{ci}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{di}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{n1i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{n2i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{x1i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{x2i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{t1i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{t2i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{m1i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{m2i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{sd1i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{sd2i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{xi}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{mi}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{ri}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{ti}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{sdi}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{r2i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{ni}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{mods}}{optional argument to include one or more moderators in the model. A single moderator can be given as a vector of length \eqn{k} specifying the values of the moderator. Multiple moderators are specified by giving a matrix with \eqn{k} rows and as many columns as there are moderator variables. Alternatively, a model \code{\link{formula}} can be used to specify the model. See \sQuote{Details}.}
    \item{\code{measure}}{character string indicating the type of data supplied to the function. When \code{measure="GEN"} (default), the observed effect sizes or outcomes and corresponding sampling variances (or standard errors) should be supplied to the function via the \code{yi}, \code{vi}, and \code{sei} arguments (only one of the two, \code{vi} or \code{sei}, needs to be specified). Alternatively, one can set \code{measure} to one of the effect size or outcome measures described under the documentation for the \code{\link[metafor]{escalc}} function and specify the needed data via the appropriate arguments.}
    \item{\code{intercept}}{logical indicating whether an intercept should be added to the model (the default is \code{TRUE}). Ignored when \code{mods} is a formula.}
    \item{\code{slab}}{optional vector with labels for the \eqn{k} studies.}
    \item{\code{subset}}{optional vector indicating the subset of studies that should be used for the analysis. This can be a logical vector of length \eqn{k} or a numeric vector indicating the indices of the observations to include.}
    \item{\code{add}}{see the documentation of the \code{\link[metafor]{escalc}} function.}
    \item{\code{to}}{see the documentation of the \code{\link[metafor]{escalc}} function.}
    \item{\code{drop00}}{see the documentation of the \code{\link[metafor]{escalc}} function.}
    \item{\code{vtype}}{see the documentation of the \code{\link[metafor]{escalc}} function.}
    \item{\code{method}}{character string specifying whether a fixed- or a random/mixed-effects model should be fitted. A fixed-effects model (with or without moderators) is fitted when using \code{method="FE"}. Random/mixed-effects models are fitted by setting \code{method} equal to one of the following: \code{"DL"}, \code{"HE"}, \code{"SJ"}, \code{"ML"}, \code{"REML"}, \code{"EB"}, \code{"HS"}, or \code{"GENQ"}. Default is \code{"REML"}. See \sQuote{Details}.}
    \item{\code{weighted}}{logical indicating whether weighted (default) or unweighted estimation should be used to fit the model.}
    \item{\code{test}}{character string specifying how test statistics and confidence intervals for the fixed effects should be computed. By default (\code{test="z"}), Wald-type tests and CIs are obtained, which are based on a standard normal distribution. When \code{test="knha"}, the method by Knapp and Hartung (2003) is used for adjusting test statistics and confidence intervals. See \sQuote{Details}.}
    \item{\code{digits}}{integer specifying the number of decimal places to which the printed results should be rounded (if unspecified, the default is 4).}
    \item{\code{btt}}{optional vector of indices specifying which coefficients to include in the omnibus test of moderators. See \sQuote{Details}.}
    \item{\code{verbose}}{logical indicating whether output should be generated on the progress of the model fitting (the default is \code{FALSE}). Can also be an integer. Values > 1 generate more verbose output. See \sQuote{Note}.}
    \item{\code{control}}{optional list of control values for the iterative estimation algorithms. If unspecified, default values are defined inside the function. See \sQuote{Note}.}
  }}
}
\description{
This analysis is carried out using the \code{metafor} package. For
more, see \code{?metafor::rma}.
}
\examples{
\donttest{
# setup
set.seed(123)
library(statsExpressions)

# let's create a dataframe
df_results <-
  structure(
    .Data = list(estimate = c(
      0.382047603321706, 0.780783111514665,
      0.425607573765058, 0.558365541235078, 0.956473848429961
    ), std.error = c(
      0.0465576338644502,
      0.0330218199731529, 0.0362834986178494, 0.0480571500648261, 0.062215818388157
    ), t.value = c(
      8.20590677855356, 23.6444603038067, 11.7300588415607,
      11.6187818146078, 15.3734833553524
    ), conf.low = c(
      0.290515146096969,
      0.715841986960399, 0.354354575031406, 0.46379116008131, 0.827446138277154
    ), conf.high = c(
      0.473580060546444, 0.845724236068931, 0.496860572498711,
      0.652939922388847, 1.08550155858277
    ), p.value = c(
      3.28679518728519e-15,
      4.04778497135963e-75, 7.59757330804449e-29, 5.45155840151592e-26,
      2.99171217913312e-13
    ), df.residual = c(
      394L, 358L, 622L, 298L,
      22L
    )),
    row.names = c(NA, -5L),
    class = c("tbl_df", "tbl", "data.frame")
  )

# making subtitle
expr_meta_parametric(
  data = df_results,
  k = 3,
  messages = FALSE
)

# getting tidy data frame with coefficients
expr_meta_parametric(
  data = df_results,
  messages = FALSE,
  output = "tidy"
)

# making caption
expr_meta_parametric(
  data = df_results,
  k = 2,
  messages = FALSE,
  output = "caption"
)

# getting dataframe with model summary
expr_meta_parametric(
  data = df_results,
  messages = FALSE,
  output = "glance"
)
}
}
