% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-easystats.R
\name{tidy_model_parameters}
\alias{tidy_model_parameters}
\title{Convert \code{{parameters}} package output to \code{{tidyverse}} conventions}
\usage{
tidy_model_parameters(model, ...)
}
\arguments{
\item{model}{Statistical Model.}

\item{...}{Arguments passed to or from other methods. Non-documented
arguments are \code{digits}, \code{p_digits}, \code{ci_digits} and \code{footer_digits} to set
the number of digits for the output. If \code{s_value = TRUE}, the p-value will
be replaced by the S-value in the output (cf. \emph{Rafi and Greenland 2020}).
\code{pd} adds an additional column with the \emph{probability of direction} (see
\code{\link[bayestestR:p_direction]{bayestestR::p_direction()}} for details). \code{groups} can be used to group
coefficients. It will be passed to the print-method, or can directly be used
in \code{print()}, see documentation in \code{\link[parameters:print.parameters_model]{print.parameters_model()}}. Furthermore,
see 'Examples' in \code{\link[parameters:model_parameters.default]{model_parameters.default()}}. For developers, whose
interest mainly is to get a "tidy" data frame of model summaries, it is
recommended to set \code{pretty_names = FALSE} to speed up computation of the
summary table.}
}
\description{
Convert \code{{parameters}} package output to \code{{tidyverse}} conventions
}
\examples{
model <- lm(mpg ~ wt + cyl, data = mtcars)
tidy_model_parameters(model)
}
