% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov_approx.R
\name{Covariance Approximation}
\alias{Covariance Approximation}
\alias{cov_approx_randwalk}
\alias{cov_approx_blockdiag}
\title{Best Approximation to Covariance Structure}
\usage{
cov_approx_randwalk(Delta, S)

cov_approx_blockdiag(Delta, S)
}
\arguments{
\item{Delta}{Covariance (\eqn{n \times n}) for observations within a time
point for the process whose variance we wish to approximate.}

\item{S}{Design matrix (\eqn{N \times r}) of basis functions evaluated on
the fine-level process over \eqn{T = N / n} time points.}
}
\description{
Compute the best positive approximant for use in the STCOS
model, under several prespecified covariance structures.
}
\details{
Let \eqn{\bm{\Sigma}} be an \eqn{N \times N} symmetric and positive-definite
covariance matrix, which we would like to approximate in the STCOS model.
Let \eqn{\bm{S}} be the \eqn{N \times r} design matrix of the basis
function computed on \eqn{T} time steps of the fine-level support.
The number of observations at each time point is assumed to be \eqn{n},
so that the number of total observations is \eqn{N = n T}.

The objective is to compute a symmetric positive-definite matrix
\eqn{\bm{K}} which minimizes
\deqn{
  || \bm{\Sigma} - \bm{S} \bm{C} \bm{S}^\top {||}_\textrm{F},
}
where \eqn{|| \cdot {||}_\textrm{F}} represents the Frobenius norm. The
solution is given by
\deqn{
  \bm{K} = (\bm{S}^\top \bm{S})^{-1} \bm{S}^\top \bm{\Sigma} \bm{S} (\bm{S}^\top \bm{S})^{-1}.
}

We provide functions to handle some possible structures for the target
covariance, which are all in the form
\deqn{
  \bm{\Sigma} =
  \left(
  \begin{array}{ccc}
  \bm{\Gamma}(1,1) & \cdots & \bm{\Gamma}(1,T) \\
  \vdots           & \ddots & \vdots \\
  \bm{\Gamma}(T,1) & \cdots & \bm{\Gamma}(T,T)
  \end{array}
  \right).
}

\itemize{
\item \code{cov_approx_randwalk} assumes \eqn{\bm{\Sigma}} is based on the
autocovariance function of a random walk
\deqn{
  \bm{Y}_{t+1} = \bm{Y}_{t} + \bm{\epsilon}_t, \quad \bm{\epsilon}_t \sim \textrm{N}(\bm{0}, \bm{\Delta}).
}
so that
\deqn{
  \bm{\Gamma}(s,t) = \min(s,t) \bm{\Delta}.
}

\item \code{cov_approx_blockdiag} assumes \eqn{\bm{\Sigma}} is based on
\deqn{
  \bm{Y}_{t+1} = \bm{Y}_{t} + \bm{\epsilon}_t, \quad \bm{\epsilon}_t \sim \textrm{N}(\bm{0}, \bm{\Delta}).
}
which are independent across \eqn{t}, so that
\deqn{
  \bm{\Gamma}(s,t) = I(s = t) \bm{\Delta},
}
}
In any case \eqn{\bm{\Sigma}} may be large and we avoid computing it in its entirety.
}
