% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov_approx.R
\name{Covariance Approximation}
\alias{Covariance Approximation}
\alias{cov_approx_randwalk}
\alias{cov_approx_blockdiag}
\title{Best Approximation to Covariance Structure}
\usage{
cov_approx_randwalk(Delta, S)

cov_approx_blockdiag(Delta, S)
}
\arguments{
\item{Delta}{Covariance (\eqn{n \times n}) for observations within a time
point for the process whose variance we wish to approximate.}

\item{S}{Design matrix (\eqn{N \times r}) of basis functions evaluated on
the fine-level process over \eqn{T = N / n} time points.}
}
\description{
Compute the best positive approximant for use in the STCOS
model, under several prespecified covariance structures.
}
\details{
Let \eqn{\bm{\Sigma}} be an \eqn{N \times N} symmetric and positive-definite
covariance matrix and \eqn{\bm{S}} be an \eqn{N \times r} matrix with
rank \eqn{r}. The objective is to compute a matrix \eqn{\bm{K}} which minimizes
the Frobenius norm
\deqn{
  \Vert \bm{\Sigma} - \bm{S} \bm{C} \bm{S}^\top {\Vert}_\textrm{F},
}
over symmetric positive-definite matrices \eqn{\bm{C}}. The
solution is given by
\deqn{
  \bm{K} = (\bm{S}^\top \bm{S})^{-1} \bm{S}^\top \bm{\Sigma} \bm{S} (\bm{S}^\top \bm{S})^{-1}.
}

In the STCOS model, \eqn{\bm{S}} represents the design matrix from a basis
function computed from a fine-level support having \eqn{n} areas, using
\eqn{T} time steps. Therefore \eqn{N = n T} represents the dimension of
covariance for the fine-level support.

We provide functions to handle some possible structures for target
covariance matrices of the form
\deqn{
  \bm{\Sigma} =
  \left(
  \begin{array}{ccc}
  \bm{\Gamma}(1,1) & \cdots & \bm{\Gamma}(1,T) \\
  \vdots           & \ddots & \vdots \\
  \bm{\Gamma}(T,1) & \cdots & \bm{\Gamma}(T,T)
  \end{array}
  \right),
}
where each \eqn{\bm{\Gamma}(s,t)} is an \eqn{n \times n} matrix.

\itemize{
\item \code{cov_approx_randwalk} assumes \eqn{\bm{\Sigma}} is based on the
autocovariance function of a random walk
\deqn{
  \bm{Y}_{t+1} = \bm{Y}_{t} + \bm{\epsilon}_t, \quad \bm{\epsilon}_t \sim \textrm{N}(\bm{0}, \bm{\Delta}).
}
so that
\deqn{
  \bm{\Gamma}(s,t) = \min(s,t) \bm{\Delta}.
}

\item \code{cov_approx_blockdiag} assumes \eqn{\bm{\Sigma}} is based on
\deqn{
  \bm{Y}_{t+1} = \bm{Y}_{t} + \bm{\epsilon}_t, \quad \bm{\epsilon}_t \sim \textrm{N}(\bm{0}, \bm{\Delta}).
}
which are independent across \eqn{t}, so that
\deqn{
  \bm{\Gamma}(s,t) = I(s = t) \bm{\Delta},
}
}
The block structure is used to reduce the computational burden, as \eqn{N}
may be large.
}
