% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_stdmod_lavaan.R
\name{coef.stdmod_lavaan}
\alias{coef.stdmod_lavaan}
\title{Standardized Moderation Effect in a 'stdmod_lavaan' Class Object}
\usage{
\method{coef}{stdmod_lavaan}(object, ...)
}
\arguments{
\item{object}{The output of \code{\link[=stdmod_lavaan]{stdmod_lavaan()}}.}

\item{...}{Optional arguments. Ignored by the function.}
}
\value{
A scalar: The estimate of the standardized moderation effect.
}
\description{
Return the estimate of the standardized
moderation effect
in the output of \code{\link[=stdmod_lavaan]{stdmod_lavaan()}}.
}
\details{
It just extracts and returns the element \code{stdmod}.
}
\examples{

# Load a test data of 500 cases
dat <- test_mod1
library(lavaan)

mod <-
"
med ~ iv + mod + iv:mod + cov1
dv ~ med + cov2
"
fit <- sem(mod, dat)
coef(fit)

# Compute the standardized moderation effect
out_noboot <- stdmod_lavaan(fit = fit,
                            x = "iv",
                            y = "med",
                            w = "mod",
                            x_w = "iv:mod")
coef(out_noboot)

# Compute the standardized moderation effect and
# its confidence interval based on nonparametric bootstrapping
set.seed(8479075)
system.time(out_boot <- stdmod_lavaan(fit = fit,
                                      x = "iv",
                                      y = "med",
                                      w = "mod",
                                      x_w = "iv:mod",
                                      boot_ci = TRUE,
                                      R = 50))
# In real analysis, R should be at least 2000.
coef(out_boot)

}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
