% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOperations_Transaction.R
\name{getOperations_Transaction}
\alias{getOperations_Transaction}
\title{Get an overview of operations for a transaction on the Stellar ledger.}
\usage{
getOperations_Transaction(hash, cursor = NULL, limit = 10, order = "asc",
  data.table = TRUE)
}
\arguments{
\item{hash}{character = the transaction id.}

\item{cursor}{numeric - optional, a paging token - where to start from. Can also be "now".}

\item{limit}{numeric - optional, the number of records to return. Default is 10.}

\item{order}{character - optional, "asc" or "desc"}

\item{data.table}{boolean - if TRUE, a data.table is returned. If FALSE or NULL, a list is returned.}
}
\value{
data.table (default) or list
}
\description{
Returns all operations that were included in a specific transactions. Converts the JSON response to a list.
}
\note{
https://www.stellar.org/developers/horizon/reference/endpoints/operations-for-transaction.html
}
\examples{
\donttest{getOperations_Transaction("someHash")}
}
