% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_effects.R
\name{rootResetRandomEffectsTracker}
\alias{rootResetRandomEffectsTracker}
\title{Reset a \code{RandomEffectsTracker} object to its "default" state}
\usage{
rootResetRandomEffectsTracker(rfx_tracker, rfx_model, rfx_dataset, residual)
}
\arguments{
\item{rfx_tracker}{Object of type \code{RandomEffectsTracker}.}

\item{rfx_model}{Object of type \code{RandomEffectsModel}.}

\item{rfx_dataset}{Object of type \code{RandomEffectsDataset}.}

\item{residual}{Object of type \code{Outcome}.}
}
\value{
None
}
\description{
Reset a \code{RandomEffectsTracker} object to its "default" state
}
\examples{
n <- 100
p <- 10
rfx_group_ids <- sample(1:2, size = n, replace = TRUE)
rfx_basis <- matrix(rep(1.0, n), ncol=1)
rfx_dataset <- createRandomEffectsDataset(rfx_group_ids, rfx_basis)
y <- (-2*(rfx_group_ids==1)+2*(rfx_group_ids==2)) + rnorm(n)
y_std <- (y-mean(y))/sd(y)
outcome <- createOutcome(y_std)
rng <- createCppRNG(1234)
num_groups <- length(unique(rfx_group_ids))
num_components <- ncol(rfx_basis)
alpha_init <- c(1)
xi_init <- matrix(rep(alpha_init, num_groups),num_components,num_groups)
sigma_alpha_init <- diag(1,num_components,num_components)
sigma_xi_init <- diag(1,num_components,num_components)
sigma_xi_shape <- 1
sigma_xi_scale <- 1
rfx_model <- createRandomEffectsModel(num_components, num_groups)
rfx_tracker <- createRandomEffectsTracker(rfx_group_ids)
rfx_samples <- createRandomEffectSamples(num_components, num_groups, rfx_tracker)
for (i in 1:3) {
    rfx_model$sample_random_effect(rfx_dataset=rfx_dataset, residual=outcome, 
                                   rfx_tracker=rfx_tracker, rfx_samples=rfx_samples, 
                                   keep_sample=TRUE, global_variance=1.0, rng=rng)
}
rootResetRandomEffectsModel(rfx_model, alpha_init, xi_init, sigma_alpha_init,
                            sigma_xi_init, sigma_xi_shape, sigma_xi_scale)
rootResetRandomEffectsTracker(rfx_tracker, rfx_model, rfx_dataset, outcome)
}
