% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targetall.R
\name{targetall}
\alias{targetall}
\title{Backtest a Fixed-Allocation Trading Strategy}
\usage{
targetall(tickers = NULL, intercepts = NULL, slopes = NULL, ...,
  tickers.gains = NULL, target.alls = NULL, tol = 0.05,
  rebalance.cost = 0, initial = 10000)
}
\arguments{
\item{tickers}{Character vector of ticker symbols that Yahoo! Finance 
recognizes, if you want to download data on the fly.}

\item{intercepts}{Numeric vector of values to add to daily gains for each 
ticker.}

\item{slopes}{Numeric vector of values to multiply daily gains for each ticker 
by. Slopes are multiplied prior to adding intercepts.}

\item{...}{Arguments to pass along with \code{tickers} to 
\code{\link{load_gains}}.}

\item{tickers.gains}{Numeric matrix of gains, where each column has gains for 
a particular fund.}

\item{target.alls}{Numeric vector specifying target allocations to each fund. 
If unspecified, equal allocations are used (e.g. 1/3, 1/3, 1/3 if there are 
3 funds).}

\item{tol}{Numeric value indicating how far the effective allocations can 
drift away from the targets before rebalancing.}

\item{rebalance.cost}{Numeric value specifying total cost of each rebalancing 
trade.}

\item{initial}{Numeric value specifying what value to scale initial prices 
to.}
}
\value{
List containing:
\enumerate{
\item Numeric matrix named \code{fund.balances} giving fund balances over 
time.
\item Numeric value named \code{rebalance.count} giving the number of 
rebalancing trades executed.
}
}
\description{
Implements a trading strategy aimed at maintaining a fixed allocation to each 
of several funds, rebalancing when the effective allocations deviate too far 
from the targets.
}
\examples{
# Backtest equal-allocation UPRO/VBLTX/VWEHX strategy
port <- targetall(tickers = c("UPRO", "VBLTX", "VWEHX"))
plot(port$fund.balances[, "Portfolio"])

}
\references{
Ryan, J.A. and Ulrich, J.M. (2017) quantmod: Quantitative Financial Modelling 
Framework. R package version 0.4-12, 
\url{https://CRAN.R-project.org/package=quantmod}.
}
