\name{plot.stppm}
\alias{plot.stppm}
\title{Plot of the fitted intensity of a spatio-temporal Poisson process model}
\usage{
\method{plot}{stppm}(
  x,
  scaler = c("silverman", "IQR", "sd", "var"),
  do.points = TRUE,
  print.bw = FALSE,
  zap = 1e-05,
  par = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{stppm}}

\item{scaler}{Optional. Controls the value for a scalar representation of the
spatial scale of the data.
Either a character string, \code{"silverman"} (default), \code{"IQR"},
 \code{"sd"}, or \code{"var"};
or positive numeric value(s). See \link{OS}.}

\item{do.points}{Add points to plot}

\item{print.bw}{It prints the estimated oversmoothing (\link{OS}) bandwidth selector}

\item{zap}{Noise threshold factor (default to 0.00001). A numerical value greater than or equal to 1.
If the range of pixel values is less than \code{zap * .Machine$double.eps},
 the image will be treated as constant. This avoids displaying images which
 should be constant but contain small numerical errors.}

\item{par}{Default to \code{TRUE}.}

\item{...}{additional unused argument}
}
\description{
The function plots the fitted intensity, displayed both in space and in space and time.
}
\value{No return value, called for side effects}
\examples{
\donttest{

pin <- rstpp(lambda = function(x, y, t, a) {exp(a[1] + a[2]*x)}, par = c(2, 6),
nsim = 1, seed = 2, verbose = TRUE)
inh1 <- stppm(pin, formula = ~ x)

plot(inh1)

}



}
\references{
D'Angelo, N., Adelfio, G., and Mateu, J. (2023). Locally weighted minimum contrast estimation for spatio-temporal log-Gaussian Cox processes. Computational Statistics & Data Analysis, 180, 107679.

Davies, T.M. and Hazelton, M.L. (2010), Adaptive kernel estimation of spatial relative risk, Statistics in Medicine, 29(23) 2423-2437.

Terrell, G.R. (1990). The maximal smoothing principle in density estimation, Journal of the American Statistical Association, 85, 470-477.
}
\seealso{
\link{stppm}, \link{print.stppm}, \link{summary.stppm}, \link{coef.stppm}
}
\author{
Nicoletta D'Angelo and Giada Adelfio
}
