% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.lista.R
\name{plot.lista}
\alias{plot.lista}
\title{Display LISTA functions}
\usage{
\method{plot}{lista}(x, id, ...)
}
\arguments{
\item{x}{An object of class \code{lista}}

\item{id}{The id of the LISTA to display}

\item{...}{additional unused argument}
}
\description{
This function works on the objects of class \code{lista}, 
as returned by
\code{localSTLKinhom} or \code{localSTLginhom}, plotting the specified
LISTA functions.
}
\examples{


set.seed(2)
df_net <- data.frame(x = runif(25, 0, 0.85), y = runif(25, 0, 0.85), t = runif(25))
stlp1 <- stp(df_net, L = chicagonet)
lambda <- rep(diff(range(stlp1$df$x)) * diff(range(stlp1$df$y))
 * diff(range(stlp1$df$t)) / spatstat.geom::volume(stlp1$L),
nrow(stlp1$df))

k <- localSTLKinhom(stlp1, lambda = lambda, normalize = TRUE)

plot(k, id = 1:9)



}
\references{
D’Angelo, N., Adelfio, G., and Mateu, J. (2021). Assessing local differences between the spatio-temporal second-order structure of two point patterns occurring on the same linear network. Spatial Statistics, 45, 100534.

D’Angelo, N., Adelfio, G.,  and Mateu, J. (2022). Local inhomogeneous second-order characteristics for spatio-temporal point processes on linear networks. Stat Papers. https://doi.org/10.1007/s00362-022-01338-4
}
\seealso{
\link{localSTLKinhom}, \link{localSTLginhom}
}
\author{
Nicoletta D'Angelo
}
