% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_session_questions.R
\name{get_session_questions}
\alias{get_session_questions}
\title{Parliamentary questions in a session}
\usage{
get_session_questions(sessionid = NA, q_type = NA, status = NA, good_manners = 0)
}
\arguments{
\item{sessionid}{Character string indicating the id of the session to request interpellations from}

\item{q_type}{Character string indicating type of question to retrieve.
Options are "interpellasjoner" (interpellations), "sporretimesporsmal" (oral questions), or "skriftligesporsmal" (written questions).}

\item{status}{Character string question status extraction. Possible values are NA (extract all questions), "til_behandling" (pending questions),
"trukket" (withdrawn questions), "bortfalt" (lapsed questions), or "alle" (all questions)}

\item{good_manners}{Integer. Seconds delay between calls when making multiple calls to the same function}
}
\value{
A data.frame with the following variables:\tabular{ll}{
    \tab  \cr
   \strong{response_date} \tab Date of data retrieval \cr
   \strong{version} \tab Data version from the API \cr
   \strong{answ_by_id} \tab Id of minister answering question \cr
   \strong{answ_by_minister_id} \tab Department id of answering minister \cr
   \strong{answ_by_minister_title} \tab Department title of answering minister \cr
   \strong{answ_date} \tab Date answer was given \cr
   \strong{answ_on_belhalf_of} \tab Answer given on behalf of \cr
   \strong{answ_on_belhalf_of_minister_id} \tab Department id of minister given answer on behalf of \cr
   \strong{answ_on_belhalf_of_minister_title} \tab Department title of minister given answer on behalf of \cr
   \strong{topic_ids} \tab Id of relevant topics for question \cr
   \strong{moved_to} \tab Question moved to \cr
   \strong{asked_by_other_id} \tab MP id, if question was not asked by the questioning MP \cr
   \strong{id} \tab Question id \cr
   \strong{correct_person} \tab Not documented in API \cr
   \strong{correct_person_minister_id} \tab Not documented in API \cr
   \strong{correct_person_minister_title} \tab Not documented in API \cr
   \strong{sendt_date} \tab Date the question was sent \cr
   \strong{session_id} \tab Session id \cr
   \strong{question_from_id} \tab Question from MP id \cr
   \strong{question_number} \tab Question number within session \cr
   \strong{question_to_id} \tab Question directed to minister id \cr
   \strong{question_to_minister_id} \tab Question directed to minister department id \cr
   \strong{question_to_minister_title} \tab Question directed to minister department title \cr
   \strong{status} \tab Question status \cr
   \strong{title} \tab Question title \cr
   \strong{type} \tab Question type \cr
}
}
\description{
A function for retrieving all questions within a parliamentary session.
}
\examples{

\dontrun{
interp <- get_session_questions(sessionid = "2013-2014", 
                                q_type = "interpellasjoner", 
                                status = "trukket")
interp
}
}
\seealso{
\link{get_question_hour} \link{get_question}
}
