% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distance-decay-functions.R
\name{dd_loglin}
\alias{dd_loglin}
\title{log-linear distance-decay function}
\usage{
dd_loglin(x, a = 0.3, b1 = -0.2)
}
\arguments{
\item{x}{A positive vector representing distances (often in km)}

\item{a}{Positive number (usually between 0 and 1) representing
the intercept of the distance decay curve with the y axis, when x = 0.}

\item{b1}{Number representing the 'beta' distance decay parameter.
Larger negative values make the initial decay steeper.}
}
\description{
'log-linear' distance decay function with two parameters:
implementation of the formula used to fit distance to probability of
travelling by a given mode by Iacono et al. (2010).
}
\examples{
x <- 0:10 # vector of distances
a = 0.3 # default alpha value
b = 0.2 # default beta value
(res <- dd_loglin(x, a, b))
plot(x, res)

x = seq(0, 50, 0.1)
plot(x, dd_loglin(x))
lines(x, dd_loglin(x, a = 0.1, b1 = 0.15))
}
\references{
Iacono, M., Krizek, K. J. and El-Geneidy, A. (2010).
Measuring non-motorized accessibility: issues, alternatives, and execution. Journal of Transport Geography, 18(1).
}

