% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/overline.R
\name{islines}
\alias{islines}
\title{Do the intersections between two geometries create lines?}
\usage{
islines(g1, g2)
}
\arguments{
\item{g1}{A SpatialLinesDataFrame}

\item{g2}{A SpatialLinesDataFrame}
}
\description{
This is a function required in \code{\link{overline}}. It identifies
whether sets of lines overlap (beyond shared points) or
not.
}
\examples{
\dontrun{
data(routes_fast)
rnet <- overline(routes_fast[c(2, 3, 22),], attrib = "length")
r1 <- routes_fast[2,]
r2 <- routes_fast[3,]
r3 <- routes_fast[22,]
plot(rnet)
lines(r3, col = "red") # line without overlaps
islines(r1, r2)
islines(r1, r3)
islines(r2, r3)

}
}

