% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_projected.R
\name{geo_buffer}
\alias{geo_buffer}
\title{Perform a buffer operation on a temporary projected CRS}
\usage{
geo_buffer(shp, dist = NULL, width = NULL, ...)
}
\arguments{
\item{shp}{A spatial object with a geographic CRS (e.g. WGS84)
around which a buffer should be drawn}

\item{dist}{The distance (in metres) of the buffer (when buffering simple features)}

\item{width}{The distance (in metres) of the buffer (when buffering sp objects)}

\item{...}{Arguments passed to the buffer (see \code{?sf::st_buffer} for details)}
}
\description{
This function solves the problem that buffers will not be circular when used on
non-projected data.
}
\details{
Requires recent version of PROJ (>= 6.3.0).
Buffers on \code{sf} objects with geographic (lon/lat) coordinates can also
be done with the \href{https://r-spatial.github.io/s2/}{\code{s2}} package.
}
\examples{
lib_versions <- sf::sf_extSoftVersion()
lib_versions
if (lib_versions[3] >= "6.3.1") {
  buff_sf <- geo_buffer(routes_fast_sf, dist = 50)
  plot(buff_sf$geometry)
  geo_buffer(routes_fast_sf$geometry, dist = 50)
}
}
\seealso{
Other geo: 
\code{\link{bbox_scale}()},
\code{\link{geo_bb_matrix}()},
\code{\link{geo_bb}()},
\code{\link{geo_length}()},
\code{\link{geo_projected}()},
\code{\link{geo_select_aeq}()},
\code{\link{quadrant}()}
}
\concept{geo}
