% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simdata_pobs_cont.R
\name{sim_pobs}
\alias{sim_pobs}
\title{Multi-dimension simulation function for data with partially observed covariates (multidimensional GenSPM) with arbitrary intervals}
\usage{
sim_pobs(N = 10, aH = -0.05, aL = -0.01, f1H = 60, f1L = 80,
  QH = 2e-08, QL = 2.5e-08, fH = 60, fL = 80, bH = 4, bL = 5,
  mu0H = 8e-06, mu0L = 1e-05, thetaH = 0.08, thetaL = 0.1, p = 0.25,
  ystart = 80, tstart = 30, tend = 105, dt = 1, sd0 = 1,
  mode = "observed", gomp = FALSE, nobs = NULL)
}
\arguments{
\item{N}{Number of individuals.}

\item{aH}{A k by k matrix, which characterize the rate of the adaptive response when Z = 1.}

\item{aL}{A k by k matrix, which characterize the rate of the adaptive response when Z = 0.}

\item{f1H}{A particular state, which if a deviation from the normal (or optimal) when Z = 1.
This is a vector with length of k.}

\item{f1L}{A particular state, which if a deviation from the normal (or optimal) when Z = 0. 
This is a vector with length of k.}

\item{QH}{A matrix k by k, which is a non-negative-definite symmetric matrix when Z = 1.}

\item{QL}{A matrix k by k, which is a non-negative-definite symmetric matrix when Z = 0.}

\item{fH}{A vector-function (with length k) of the normal (or optimal) state when Z = 1.}

\item{fL}{A vector-function (with length k) of the normal (or optimal) state when Z = 0.}

\item{bH}{A diffusion coefficient, k by k matrix when Z = 1.}

\item{bL}{A diffusion coefficient, k by k matrix when Z = 0.}

\item{mu0H}{mortality at start period of time when Z = 1.}

\item{mu0L}{mortality at start period of time when Z = 0.}

\item{thetaH}{A displacement coefficient of the Gompertz function when Z = 1.}

\item{thetaL}{A displacement coefficient of the Gompertz function when Z = 0.}

\item{p}{A proportion of carriers in a sumulated population (default p = 0.25).}

\item{ystart}{A vector with length equal to number of dimensions used, defines starting values of covariates.}

\item{tstart}{A number that defines starting time (30 by default).}

\item{tend}{A number, defines final time (105 by default).}

\item{dt}{A discrete step size between two observations. A random uniform value is then added to this step size.}

\item{sd0}{A standard deviation for modelling the next physiological variable (covariate) value.}

\item{mode}{Can have the following values: "observed" (default), "unobserved".
This represents a type of group to simulate: a group with observed variable Z, or group with unbobserved variable Z.}

\item{gomp}{A flag (FALSE by default). When it is set, then time-dependent exponential form of mu0 and Q are used:
mu0 = mu0*exp(theta*t).}

\item{nobs}{A number of observations (lines) for individual observations.}
}
\value{
A table with simulated data.
}
\description{
Multi-dimension simulation function for data with partially observed covariates (multidimensional GenSPM) with arbitrary intervals
}
\examples{
library(stpm)
dat <- sim_pobs(N=50)
head(dat)

}
\references{
Arbeev, K.G. et al (2009). Genetic model for longitudinal studies of aging, health, and longevity

Yashin, A.I. et al (2007). Stochastic model for analysis of longitudinal data on aging 
and mortality. Mathematical Biosciences, 208(2), 538-551.<DOI:10.1016/j.mbs.2006.11.006>.
}

