% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{dimlabels<-}
\alias{dimlabels<-}
\title{Add Elements to Vectors}
\usage{
dimlabels(x) <- value
}
\arguments{
\item{x}{array or any object with dimnames. The object may or may not already have
dimlabels.}

\item{value}{character vector of dimlabels to be added to \code{x}. If
\code{`dimlabels<-`} is used on its own, then the length of \code{value} must
be the same as ndim. If \code{`dimlabels<-`} is used in confunction with the subsetting
function \code{`[[<-`} or \code{`[<-`}, then the length of \code{values} should
be equal to the length of dimlabels after from the subsetting. This is the same
way \code{`names<-`} works.}
}
\value{
Like other similar functions (e.g., \code{`names<-`} and \code{`[<-`}),
it does not appear to have a return object. However, it technically does as a
side effect. The argument \code{x} will have been changed such that \code{value}
has been added as dimlabels. If a traditional return object is desired, and no side
effects, then it can be called like a traditional function:
obj2 <- `dimlabels<-`(x = obj, value = dimlab).
}
\description{
\code{`dimlabels<-`} adds elements to vectors as a side effect. The purpose of
the function is to replace \code{names(dimnames(x))} with a single function call.
}
\examples{
a <- array(c(letters, NA), dim = c(3,3,3),
   dimnames = replicate(3, expr = 1:3, simplify = FALSE))
dimlabels(a) <- c("first","second","third")
dimlabels(a)[[2]] <- c("2nd")
dimlabels(a)[c(1,3)] <- c("1st","3rd")
print(a)
}
