% Generated by roxygen2 (4.0.2): do not edit by hand
\name{gen.data.from.freq}
\alias{gen.data.from.freq}
\title{Convert Haplotype Frequency Matrices}
\usage{
gen.data.from.freq(freq.mat, hap.col, freq.col, id.label = NULL,
  hap.label = NULL)
}
\arguments{
\item{freq.mat}{a matrix or data.frame containing haplotypic frequencies with strata as column names.}

\item{hap.col}{a number giving the column providing haplotype labels or a vector the same length as freq.mat.}

\item{freq.col}{a number giving the first column containing haplotype frequencies.}

\item{id.label}{character to label sample IDs with in resulting data.frame.}

\item{hap.label}{character to label haplotypes with in resulting data.frame.}
}
\value{
a data.frame with one row per sample and columns for id, strata, and haplotype.
}
\description{
Create a data.frame of stratified individuals and their haplotypes from a frequency table
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

