% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_methods.R
\name{plot.auto_strata}
\alias{plot.auto_strata}
\title{Plot method for \code{auto_strata} object}
\usage{
\method{plot}{auto_strata}(
  x,
  type = "SR",
  label = FALSE,
  stratum = "all",
  strata_lines = TRUE,
  jitter_prognosis,
  jitter_propensity,
  propensity,
  ...
)
}
\arguments{
\item{x}{an \code{auto_strata} object returned by \code{\link{auto_stratify}}}

\item{type}{string giving the plot type (default = \code{"SR"}).  Other
options are \code{"hist"}, \code{"AC"} and \code{"residual"}}

\item{label}{ignored unless \code{type = "SR"}. If \code{TRUE}, a clickable
plot is produced. The user may click on any number of strata and press
finish to have those strata labeled.  Note: uses \code{\link{identify}},
which may not be supported on some devices}

\item{stratum}{ignored unless \code{type = "hist"} or \code{type = "AC"}. A
number specifying which stratum to plot.}

\item{strata_lines}{default = \code{TRUE}. Ignored unless \code{type = "AC"}.
If TRUE, lines on the plot indicate strata cut points.}

\item{jitter_prognosis}{ignored unless \code{type = "AC"}.  Amount of uniform
random noise to add to prognostic scores in plot.}

\item{jitter_propensity}{ignored unless \code{type = "AC"}.  Amount of
uniform random noise to add to propensity scores in plot.}

\item{propensity}{ignored unless \code{type = "hist"} or \code{type = "AC"}.
Specifies propensity score information for plots where this is required.
Accepts either a vector of propensity scores, a \code{glm} model for
propensity scores, or a formula for fitting a propensity score model.}

\item{...}{other arguments}
}
\description{
Generates diagnostic plots for the product of a stratification by
\code{\link{auto_stratify}}.  There are four plot types: \enumerate{ \item
\code{"SR"} (default) - produces a scatter plot of strata by size and
treat:control ratio \item \code{"hist"} - produces a histogram of propensity
scores within a stratum \item \code{"AC"} - produces a Assignment-Control
plot of individuals within a stratum \item \code{"residual"} - produces a
residual plot for the prognostic model}
}
\examples{
dat <- make_sample_data()
a.strat <- auto_stratify(dat, "treat", outcome ~ X1 + X2)
plot(a.strat) # makes size-ratio scatter plot
plot(a.strat, type = "hist", propensity = treat ~ X1, stratum = 1)
plot(a.strat, type = "AC", propensity = treat ~ X1, stratum = 1)
plot(a.strat, type = "residual")
}
\seealso{
Aikens, Greaves, and Baiocchi (2020) in Statistics in Medicine,
  Section 3.2 for an explaination of Assignment-Control plots (formerly
  "Fisher-Mill" plots).

\code{\link{plot.manual_strata}}
}
