% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSC.R
\name{DSC}
\alias{DSC}
\alias{DSC_R}
\alias{get_centers}
\alias{get_weights}
\alias{get_copy}
\alias{get_microclusters}
\alias{get_macroclusters}
\alias{get_microweights}
\alias{get_macroweights}
\alias{nclusters}
\title{Data Stream Clusterer Base Classes}
\usage{
DSC(...)

get_centers(x, type = c("auto", "micro", "macro"), ...)

get_weights(x, type = c("auto", "micro", "macro"), scale = NULL, ...)

get_copy(x)

get_microclusters(x, ...)

get_macroclusters(x, ...)

get_microweights(x, ...)

get_macroweights(x, ...)

nclusters(x, type = c("auto", "micro", "macro"), ...)
}
\arguments{
\item{...}{further parameter}

\item{x}{a DSC object.}

\item{type}{Return weights of micro- or macro-clusters in x.  Auto uses the
class of x to decide.}

\item{scale}{a range (from, to) to scale the weights.  Returns by default
the raw weights.}
}
\description{
Abstract base classes for all DSC (Data Stream Clusterer) and DSC_R classes.
Concrete implementations are functions starting with \code{DSC_} (R Studio use auto-completion with Tab to select one).
}
\details{
The \verb{DSC\} and }DSC_R\verb{classes cannot be instantiated (calling}DSC()\code{or}DSC_R()` produces only a message listing the available implementations),
but they serve as a base
class from which other DSC classes inherit.

Class \code{DSC} provides several generic functions that can operate on all
DSC subclasses. See Functions section below.
Additional, separately documented functions are:
\itemize{
\item \link{update} Add new data points from a stream to a clustering.
\item \link{plot} function is also provides for \code{DSC}.
\item \link{get_assignment} Find out what cluster new data points would be assigned to.
}

\code{get_centers} and \code{get_weights} are typically overwritten by
subclasses of \code{DSC}. \code{DSC_R} provides these functions for R-based
DSC implementations.

Since \code{DSC} objects often contain external pointers, regular saving and
reading operations will fail. Use \link{saveDSC} and \link{readDSC}
which will serialize the objects first appropriately.
}
\section{Functions}{
\itemize{
\item \code{get_centers}: Gets the cluster centers (micro- or macro-clusters) from a DSC object.

\item \code{get_weights}: Get the weights of the clusters in the DSC (returns 1s if not implemented by the clusterer)

\item \code{get_copy}: Create a Deep Copy of a DSC Object that contain reference classes (e.g., Java data structures for MOA).

\item \code{get_microclusters}: Get micro-clusters if the object is a \code{DSC_Micro}.

\item \code{get_macroclusters}: Get micro-clusters if the the object is a \code{DSC_Macro}.

\item \code{get_microweights}: Get micro-cluster weights if the object is a \code{DSC_Micro}.

\item \code{get_macroweights}: Get macro-cluster weights if the object is a \code{DSC_Macro}.

\item \code{nclusters}: Returns the number of micro-clusters from the DSC object.
}}

\examples{

DSC()

stream <- DSD_Gaussians(k=3, d=2)
dstream <- DSC_DStream(gridsize=.1)
update(dstream, stream, 500)
dstream

# get micro-cluster centers
get_centers(dstream)

# get the number of clusters
nclusters(dstream)

# get the micro-cluster weights
get_weights(dstream)

# D-Stream also has macro-clusters
get_weights(dstream, type="macro")


}
\seealso{
\link{DSC_Micro}, \link{DSC_Macro}, \link{animate_cluster}, \link{update},
\link{evaluate}, \link{get_assignment},
\link{microToMacro},
\link{plot}, \link{prune_clusters},
\link{recluster}, \link{readDSC}, \link{saveDSC}
}
\author{
Michael Hahsler
}
