% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSOutlier.R
\docType{class}
\name{DSOutlier}
\alias{DSOutlier}
\alias{clean_outliers}
\alias{recheck_outlier}
\alias{get_outlier_positions}
\alias{noutliers}
\title{Abstract Class for Outlier Detection Clusterers}
\usage{
DSOutlier(...)

clean_outliers(x, ...)

recheck_outlier(x, outlier_correlated_id, ...)

get_outlier_positions(x, ...)

noutliers(x, ...)
}
\arguments{
\item{...}{further arguments.}

\item{x}{The DSC object.}

\item{outlier_correlated_id}{ids of outliers.}
}
\description{
The abstract class for all outlier detection clusterers. Cannot be
instantiated. An implementation is available in package
\pkg{streamMOA}.
}
\section{Functions}{
\itemize{
\item \code{clean_outliers}: Clean Outliers from the Outlier Detecting Clusterer

\item \code{recheck_outlier}: Re-checks the outlier having \code{outlier_correlated_id}.
If this object is still an outlier, the method
returns TRUE.

\item \code{get_outlier_positions}: Returns spatial positions of all current outliers.

\item \code{noutliers}: Returns the current number
of outliers.
}}

\examples{
DSOutlier()
}
\author{
Dalibor Krleža
}
