% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arg-match.R
\name{str_match_arg}
\alias{str_match_arg}
\alias{match_arg}
\title{Argument Matching.}
\usage{
str_match_arg(arg, choices, index = FALSE, several_ok = FALSE,
  ignore_case = FALSE)

match_arg(arg, choices, index = FALSE, several_ok = FALSE,
  ignore_case = FALSE)
}
\arguments{
\item{arg}{A character vector (of length one unless \code{several_ok = TRUE}).}

\item{choices}{A character vector of candidate values.}

\item{index}{Return the index of the match rather than the match itself?
Default no.}

\item{several_ok}{Allow \code{arg} to have length greater than one to match
several arguments at once? Default no.}

\item{ignore_case}{Ignore case while matching. Default no. If this is \code{TRUE},
the returned value is the matched element of \code{choices} (with its original
casing).}
}
\description{
Match \code{arg} against a series of candidate \code{choices} where \code{NULL} means take
the first one. \code{arg} \emph{matches} an element of \code{choices} if \code{arg} is a prefix
of that element.
}
\details{
\code{ERROR}s are thrown when a match is not made and where the match is
ambiguous. However, sometimes ambiguities are inevitable. Consider the case
where \code{choices = c("ab", "abc")}, then there's no way to choose \code{"ab"}
because \code{"ab"} is a prefix for \code{"ab"} and \code{"abc"}. If this is the case, you
need to provide a full match, i.e. using \code{arg = "ab"} will get you \code{"ab"}
without an error, however \code{arg = "a"} will throw an ambiguity error.

This function inspired by \code{RSAGA::match.arg.ext()}. Its behaviour is almost
identical (the difference is that \code{RSAGA::match.arg.ext(..., ignore.case = TRUE)} guarantees that the function returns strings in all lower case, but
that is not so with \code{filesstrings::match_arg(..., ignore_case = TRUE)}) but
\code{RSAGA} is a heavy package to depend upon so \code{filesstrings::match_arg()}
might be handy for package developers.

This function is designed to be used inside of other functions. It's fine to
use it for other purposes, but the error messages might be a bit weird.
}
\examples{
choices <- c("Apples", "Pears", "Bananas", "Oranges")
match_arg(NULL, choices)
match_arg("A", choices)
match_arg("B", choices, index = TRUE)
match_arg(c("a", "b"), choices, several_ok = TRUE, ignore_case = TRUE)
match_arg(c("b", "a"), choices, ignore_case = TRUE, index = TRUE,
          several_ok = TRUE)

}
