% Generated by roxygen2 (4.0.0): do not edit by hand
\name{stri_locate_words}
\alias{stri_locate_words}
\title{Locate Words in a Text}
\usage{
stri_locate_words(str, locale = NULL)
}
\arguments{
\item{str}{character vector or an object coercible to}

\item{locale}{\code{NULL} or \code{""} for text boundary analysis following
the conventions of the default locale, or a single string with
locale identifier, see \link{stringi-locale}.}
}
\value{
A list of integer matrices
is returned. The first column gives the start positions
of the words, and the second column gives
the end positions. The indices are code point-based, thus
they may be passed e.g. to the \code{\link{stri_sub}} function.

Moreover, you may get two \code{NA}s in one row
for no match or \code{NA} arguments.
}
\description{
This function locates all words in each string.
}
\details{
Vectorized over \code{str}.

Just like in \code{\link{stri_extract_words}},
\pkg{ICU}'s word \code{BreakIterator} iterator is used
to locate word boundaries, and all non-word characters
(\code{UBRK_WORD_NONE} rule status) are ignored.
}
\examples{
stri_locate_words("  stringi: THE string processing package 123.48...  ")
}
\references{
\emph{Boundary Analysis} -- ICU User Guide,
\url{http://userguide.icu-project.org/boundaryanalysis}
}
\seealso{
Other indexing: \code{\link{stri_locate_all_charclass}},
  \code{\link{stri_locate_first_charclass}},
  \code{\link{stri_locate_first_charclass}},
  \code{\link{stri_locate_last_charclass}},
  \code{\link{stri_locate_last_charclass}};
  \code{\link{stri_locate_all_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_last_coll}},
  \code{\link{stri_locate_last_coll}};
  \code{\link{stri_locate_all_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_last_fixed}},
  \code{\link{stri_locate_last_fixed}};
  \code{\link{stri_locate_all_regex}},
  \code{\link{stri_locate_first_regex}},
  \code{\link{stri_locate_first_regex}},
  \code{\link{stri_locate_last_regex}},
  \code{\link{stri_locate_last_regex}};
  \code{\link{stri_locate_all}};
  \code{\link{stri_locate_boundaries}};
  \code{\link{stri_locate_first}};
  \code{\link{stri_locate_last}};
  \code{\link{stri_locate}}; \code{\link{stri_sub}},
  \code{\link{stri_sub<-}}

Other locale_sensitive: \code{\link{\%!==\%}},
  \code{\link{\%!=\%}}, \code{\link{\%<=\%}},
  \code{\link{\%<\%}}, \code{\link{\%===\%}},
  \code{\link{\%==\%}}, \code{\link{\%>=\%}},
  \code{\link{\%>\%}}, \code{\link{\%stri!==\%}},
  \code{\link{\%stri!=\%}}, \code{\link{\%stri<=\%}},
  \code{\link{\%stri<\%}}, \code{\link{\%stri===\%}},
  \code{\link{\%stri==\%}}, \code{\link{\%stri>=\%}},
  \code{\link{\%stri>\%}}; \code{\link{stri_cmp}},
  \code{\link{stri_cmp_eq}}, \code{\link{stri_cmp_equiv}},
  \code{\link{stri_cmp_ge}}, \code{\link{stri_cmp_gt}},
  \code{\link{stri_cmp_le}}, \code{\link{stri_cmp_lt}},
  \code{\link{stri_cmp_neq}},
  \code{\link{stri_cmp_nequiv}},
  \code{\link{stri_compare}};
  \code{\link{stri_count_coll}};
  \code{\link{stri_detect_coll}};
  \code{\link{stri_duplicated}},
  \code{\link{stri_duplicated_any}};
  \code{\link{stri_enc_detect2}};
  \code{\link{stri_extract_all_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_last_coll}},
  \code{\link{stri_extract_last_coll}};
  \code{\link{stri_extract_words}};
  \code{\link{stri_locate_all_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_last_coll}},
  \code{\link{stri_locate_last_coll}};
  \code{\link{stri_locate_boundaries}};
  \code{\link{stri_opts_collator}};
  \code{\link{stri_order}}, \code{\link{stri_sort}};
  \code{\link{stri_replace_all_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_last_coll}},
  \code{\link{stri_replace_last_coll}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_split_coll}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_unique}}; \code{\link{stri_wrap}};
  \code{\link{stringi-locale}};
  \code{\link{stringi-search-coll}}

Other search_locate: \code{\link{stri_locate_all_charclass}},
  \code{\link{stri_locate_first_charclass}},
  \code{\link{stri_locate_first_charclass}},
  \code{\link{stri_locate_last_charclass}},
  \code{\link{stri_locate_last_charclass}};
  \code{\link{stri_locate_all_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_last_coll}},
  \code{\link{stri_locate_last_coll}};
  \code{\link{stri_locate_all_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_last_fixed}},
  \code{\link{stri_locate_last_fixed}};
  \code{\link{stri_locate_all_regex}},
  \code{\link{stri_locate_first_regex}},
  \code{\link{stri_locate_first_regex}},
  \code{\link{stri_locate_last_regex}},
  \code{\link{stri_locate_last_regex}};
  \code{\link{stri_locate_all}};
  \code{\link{stri_locate_boundaries}};
  \code{\link{stri_locate_first}};
  \code{\link{stri_locate_last}};
  \code{\link{stri_locate}}; \code{\link{stringi-search}}

Other text_boundaries: \code{\link{stri_extract_words}};
  \code{\link{stri_locate_boundaries}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_wrap}}
}

