% Generated by roxygen2 (4.0.0): do not edit by hand
\name{stri_replace_all_coll}
\alias{stri_replace_all_coll}
\alias{stri_replace_first_coll}
\alias{stri_replace_last_coll}
\title{Replace Occurrences of a Canonically Equivalent Pattern Matches}
\usage{
stri_replace_all_coll(str, pattern, replacement, opts_collator = NULL)

stri_replace_first_coll(str, pattern, replacement, opts_collator = NULL)

stri_replace_last_coll(str, pattern, replacement, opts_collator = NULL)
}
\arguments{
\item{str}{character vector of strings to search in}

\item{pattern}{character vector of patterns to search for}

\item{replacement}{character vector of strings to replace with}

\item{opts_collator}{a named list with \pkg{ICU} Collator's settings
as generated with \code{\link{stri_opts_collator}}; \code{NULL}
for default settings}
}
\value{
Each function discussed returns a character vector.
}
\description{
Replaces with the given replacement string every/first/last
substring of the input that matches the pattern.
}
\details{
Vectorized over \code{str}, \code{pattern}, and \code{replacement}.

These are locale-sensitive operations.
See \link{stringi-search-coll} for more details on
locale-sensitive text searching in \pkg{stringi}.

These functions scan the input string for matches of the pattern.
Input that is not part of any match is left unchanged;
each match is replaced in the result by the replacement string.
}
\examples{
s <- "Lorem ipsum dolor sit amet, consectetur adipisicing elit."

\dontshow{if (stri_install_check(silent=TRUE))}
stri_replace_all_coll(s, " ", "#")

\dontshow{if (stri_install_check(silent=TRUE))}
stri_replace_all_coll(s, "o", "0")
}
\seealso{
Other locale_sensitive: \code{\link{\%!==\%}},
  \code{\link{\%!=\%}}, \code{\link{\%<=\%}},
  \code{\link{\%<\%}}, \code{\link{\%===\%}},
  \code{\link{\%==\%}}, \code{\link{\%>=\%}},
  \code{\link{\%>\%}}, \code{\link{\%stri!==\%}},
  \code{\link{\%stri!=\%}}, \code{\link{\%stri<=\%}},
  \code{\link{\%stri<\%}}, \code{\link{\%stri===\%}},
  \code{\link{\%stri==\%}}, \code{\link{\%stri>=\%}},
  \code{\link{\%stri>\%}}; \code{\link{stri_cmp}},
  \code{\link{stri_cmp_eq}}, \code{\link{stri_cmp_equiv}},
  \code{\link{stri_cmp_ge}}, \code{\link{stri_cmp_gt}},
  \code{\link{stri_cmp_le}}, \code{\link{stri_cmp_lt}},
  \code{\link{stri_cmp_neq}},
  \code{\link{stri_cmp_nequiv}},
  \code{\link{stri_compare}};
  \code{\link{stri_count_coll}};
  \code{\link{stri_detect_coll}};
  \code{\link{stri_duplicated}},
  \code{\link{stri_duplicated_any}};
  \code{\link{stri_enc_detect2}};
  \code{\link{stri_extract_all_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_last_coll}},
  \code{\link{stri_extract_last_coll}};
  \code{\link{stri_extract_words}};
  \code{\link{stri_locate_all_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_last_coll}},
  \code{\link{stri_locate_last_coll}};
  \code{\link{stri_locate_boundaries}};
  \code{\link{stri_locate_words}};
  \code{\link{stri_opts_collator}};
  \code{\link{stri_order}}, \code{\link{stri_sort}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_split_coll}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_unique}}; \code{\link{stri_wrap}};
  \code{\link{stringi-locale}};
  \code{\link{stringi-search-coll}}

Other search_coll: \code{\link{stri_count_coll}};
  \code{\link{stri_detect_coll}};
  \code{\link{stri_extract_all_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_last_coll}},
  \code{\link{stri_extract_last_coll}};
  \code{\link{stri_locate_all_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_last_coll}},
  \code{\link{stri_locate_last_coll}};
  \code{\link{stri_split_coll}};
  \code{\link{stringi-search-coll}};
  \code{\link{stringi-search}}

Other search_replace: \code{\link{stri_replace_all_charclass}},
  \code{\link{stri_replace_first_charclass}},
  \code{\link{stri_replace_first_charclass}},
  \code{\link{stri_replace_last_charclass}},
  \code{\link{stri_replace_last_charclass}};
  \code{\link{stri_replace_all_fixed}},
  \code{\link{stri_replace_first_fixed}},
  \code{\link{stri_replace_first_fixed}},
  \code{\link{stri_replace_last_fixed}},
  \code{\link{stri_replace_last_fixed}};
  \code{\link{stri_replace_all_regex}},
  \code{\link{stri_replace_first_regex}},
  \code{\link{stri_replace_first_regex}},
  \code{\link{stri_replace_last_regex}},
  \code{\link{stri_replace_last_regex}};
  \code{\link{stri_replace_all}};
  \code{\link{stri_replace_first}};
  \code{\link{stri_replace_last}};
  \code{\link{stri_replace_na}};
  \code{\link{stri_replace}}; \code{\link{stringi-search}}
}

