% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_format.R
\name{stri_datetime_fstr}
\alias{stri_datetime_fstr}
\title{Convert \code{strptime}-Style Format Strings}
\usage{
stri_datetime_fstr(x, ignore_special = TRUE)
}
\arguments{
\item{x}{character vector of date/time format strings}

\item{ignore_special}{if \code{FALSE}, special identifiers like
\code{"datetime_full"} or \code{date_relative_short}
(see \code{\link{stri_datetime_format}}) are left as-is}
}
\value{
Returns a character vector.
}
\description{
This function converts \code{\link[base]{strptime}} or
\code{\link[base]{strftime}}-style
format strings to \pkg{ICU} format strings that may be used
in \code{\link{stri_datetime_parse}} and \code{\link{stri_datetime_format}}
functions.
}
\details{
For more details on conversion specifiers please refer to
the manual page of \code{\link[base]{strptime}}. Most of the formatters
of the form \code{\%x}, where \code{x} is a letter, are supported.
Moreover, each \code{\%\%} is replaced with \code{\%}.

Warnings are given in the case of \code{\%x}, \code{\%X}, \code{\%u},
\code{\%w}, \code{\%g}, \code{\%G}, \code{\%c}, \code{\%U}, and \code{\%W}
as in such circumstances either \pkg{ICU} does not
support the functionality requested using the string format API
or there are some inconsistencies between base R and \pkg{ICU}.
}
\examples{
stri_datetime_fstr('\%Y-\%m-\%d \%H:\%M:\%S')

}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Gagolewski M., \pkg{stringi}: Fast and portable character string processing in R, \emph{Journal of Statistical Software} 103(2), 2022, 1-59, \doi{10.18637/jss.v103.i02}

Other datetime: 
\code{\link{stri_datetime_add}()},
\code{\link{stri_datetime_create}()},
\code{\link{stri_datetime_fields}()},
\code{\link{stri_datetime_format}()},
\code{\link{stri_datetime_now}()},
\code{\link{stri_datetime_symbols}()},
\code{\link{stri_timezone_get}()},
\code{\link{stri_timezone_info}()},
\code{\link{stri_timezone_list}()}
}
\concept{datetime}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
