% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{str_subset}
\alias{str_subset}
\alias{str_which}
\title{Keep strings matching a pattern, or find positions.}
\usage{
str_subset(string, pattern, negate = FALSE)

str_which(string, pattern, negate = FALSE)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{Pattern to look for.

The default interpretation is a regular expression, as described
in \link[stringi:about_search_regex]{stringi::stringi-search-regex}. Control options with
\code{\link[=regex]{regex()}}.

Match a fixed string (i.e. by comparing only bytes), using
\code{\link[=fixed]{fixed()}}. This is fast, but approximate. Generally,
for matching human text, you'll want \code{\link[=coll]{coll()}} which
respects character matching rules for the specified locale.

Match character, word, line and sentence boundaries with
\code{\link[=boundary]{boundary()}}. An empty pattern, "", is equivalent to
\code{boundary("character")}.}

\item{negate}{If \code{TRUE}, return non-matching elements.}
}
\value{
A character vector.
}
\description{
\code{str_subset()} is a wrapper around \code{x[str_detect(x, pattern)]},
and is equivalent to \code{grep(pattern, x, value = TRUE)}.
\code{str_which()} is a wrapper around \code{which(str_detect(x, pattern))},
and is equivalent to \code{grep(pattern, x)}.
See \code{\link[=str_detect]{str_detect()}} for an equivalent to \code{grepl(pattern, x)}.
}
\details{
Vectorised over \code{string} and \code{pattern}
}
\examples{
fruit <- c("apple", "banana", "pear", "pinapple")
str_subset(fruit, "a")
str_which(fruit, "a")

str_subset(fruit, "^a")
str_subset(fruit, "a$")
str_subset(fruit, "b")
str_subset(fruit, "[aeiou]")

# Returns elements that do NOT match
str_subset(fruit, "^p", negate = TRUE)

# Missings never match
str_subset(c("a", NA, "b"), ".")
str_which(c("a", NA, "b"), ".")
}
\seealso{
\code{\link[=grep]{grep()}} with argument \code{value = TRUE},
\code{\link[stringi:stri_subset]{stringi::stri_subset()}} for the underlying implementation.
}
