% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stylest_term_influence.R
\name{stylest_term_influence}
\alias{stylest_term_influence}
\title{Compute the influence of terms}
\usage{
stylest_term_influence(model, text, speaker)
}
\arguments{
\item{model}{\code{stylest_model} object}

\item{text}{Text vector. May be a \code{corpus_frame} object}

\item{speaker}{Vector of speaker labels. Should be the same length as
\code{x}}
}
\value{
\code{data.frame} with columns representing terms, their mean influence,
and their maximum influence
}
\description{
Compute the influence of terms
}
\examples{
data(novels_excerpts)
speaker_mod <- stylest_fit(novels_excerpts$text, novels_excerpts$author)
stylest_term_influence(speaker_mod, novels_excerpts$text, novels_excerpts$author)
  
}
