% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wainer.score.R
\name{Wainer.score}
\alias{Wainer.score}
\title{Estimating true subscores using Wainer's augmentation method}
\usage{
Wainer.score(test.data)
}
\arguments{
\item{test.data}{A list that contains datasets of all subtests and the total test, which can be obtained using function 'data.prep'.}
}
\value{
\item{summary}{It contains statistical summary of the augmented subscores (mean, sd, and reliability).}
\item{Augmented.subscores}{It contains augmented subscores that are obtained using Wainer's method.}
}
\description{
This function estimates subscores using Wainer's augmentation method (Wainer et. al., 2001). 
The central idea of this 
procedure is that, the estimation of subscores will be improved by shrinking the individual 
observed subscores towards some aggregate values (i.e., group mean subscores). The extent of 
the shrinkage depends on the closeness of the subscale being estimated with other subscales as 
well as reliabilities of all the subscales. Wainer's augmentation is a multivariate version of 
Kelly's formula (Kelly, 1947). For details of Wainer's augmentation subscoring method, please refer to Wainer et al. (2001).
}
\examples{
 
       test.data<-data.prep(scored.data,c(3,15,15,20))
        
        Wainer.score(test.data)
        
        Wainer.score(test.data)$summary
        Wainer.score(test.data)$subscore.augmented
}
\references{
{
Wainer, H., Vevea, J., Camacho, F., Reeve, R., Rosa, K., Nelson, L., Swygert, K., & Thissen, D. (2001). 
"Augmented scores - "Borrowing strength" to compute scores based on small numbers of items"
 In Thissen, D. & Wainer, H. (Eds.), Test scoring (pp.343 - 387). Mahwah, NJ: Lawrence Erlbaum Associates, Inc. 
}
}

