#'Subspace: An R-Interface to the Subspace and Projected Clustering Algorithms 
#'of the OpenSubspace package
#'
#'This package provides access to five of the most popular clustering algorithms
#'in the subspace paradigm.
#'
#'The algorithms \code{\link{CLIQUE}}, \code{\link{P3C}}, \code{\link{ProClus}}, 
#'\code{\link{SubClu}} and \code{\link{FIRES}} can be applied to data.frames and matrices and will 
#'return S3 objects representing clusterings. For example, using the built-in 
#'demo dataset, you can do:
#'
#'\code{>data("subspace_dataset")}\cr \code{>clustering <-
#'P3C(subspace_dataset,PoissonThreshold=2)}\cr \code{>clustering}\cr 
#'\code{Subspace clustering generated by the package Subspace, containing 12
#'clusters.}
#'
#'These \emph{subspace_clustering} objects are actually just lists of
#'\emph{subspace_cluster} objects, which can be accessed as follows.
#'
#'\code{>clustering[[1]]} \cr \code{Subspace cluster generated by the package
#'Subspace. This cluster consists of 140 objects in a 3 dimensional subspace.}
#'
#'Each of these clusters then holds a vector representing its subspace and a 
#'vector with the indexes of the objects the belong in this cluster. In this
#'example, these could be accessed as \code{clustering[[1]]$objects} and 
#'\code{clustering[[1]]$subspace}.
#'
#'This package also provides a \code{\link{plot}} method for
#'\emph{subspace_clustering} objects:
#'
#'\code{>plot(clustering,subspace_dataset)}\cr \code{Showing dynamic
#'visualisation. Press Escape/Ctrl + C to stop.}
#'
#'These plots are created using the \code{\link{ggvis}} package.
#'
#'Finally, you can save clusterings to a file using the
#'\code{\link{clustering_from_file}} and \code{\link{clustering_to_file}} 
#'functions.
#'
#'For example you could save the clustering from this example to a file and load the true clustering of the
#'demo dataset:
#'
#'\code{>clustering_to_file(clustering,file_path="clustering.txt")}\cr
#'\code{>path_to_clustering <- paste(path.package("subspace"),"/extdata/subspace_dataset.true",sep="")}\cr
#'\code{true_clustering <- clustering_from_file(file_path=path_to_clustering)}
#'
#'
#'@references Müller E., Günnemann S., Assent I., Seidl T.:
#'Evaluating Clustering in Subspace Projections of High Dimensional Data
#'http://dme.rwth-aachen.de/OpenSubspace/
#'In Proc. 35th International Conference on Very Large Data Bases (VLDB 2009), Lyon, France. (2009) 
#'
#'@docType package
#'@name subspace
NULL