% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allocate.R
\name{allocate}
\alias{allocate}
\title{Allocate polygon centroids to hexagons in a grid}
\usage{
allocate(
  centroids,
  hex_grid,
  sf_id = names(centroids)[1],
  hex_size,
  hex_filter,
  use_neighbours = neighbours,
  focal_points = NULL,
  width,
  verbose
)
}
\arguments{
\item{centroids}{a data frame with centroids of non empty polygons}

\item{hex_grid}{a data frame containing all possible hexagon points}

\item{sf_id}{a string to indicate the column to identify individual polygons}

\item{hex_size}{a float value in degrees for the diameter of the hexagons}

\item{hex_filter}{amount of hexagons around centroid to consider}

\item{use_neighbours}{providing the sf data set to find spatial neighbours}

\item{focal_points}{a data frame of reference locations when allocating
hexagons, capital cities of Australia are used in the example}

\item{width}{a numeric indicating the angle used to filter the hexagon grid}

\item{verbose}{a boolean to indicate whether to show polygon id}
}
\value{
a data frame of all allocated hexagon points
}
\description{
Chooses a hexagon centroid for each polygon in the shape file, from a grid
spanning the longitudes and latitudes in the expanded bounding box.
}
\examples{
# Create centroids set
centroids <- create_centroids(tas_lga, sf_id = "LGA_CODE16")
# Create hexagon location grid
data(capital_cities)
grid <- create_grid(centroids = centroids, hex_size = 0.2, buffer_dist = 1.2)
# Allocate polygon centroids to hexagon grid points
hex_allocated <- allocate(
  centroids = centroids,
  hex_grid = grid,
  hex_size = 0.2, # same size used in create_grid
  hex_filter = 10,
  use_neighbours = tas_lga,
  focal_points = capital_cities,
  width = 30, verbose = TRUE
)
# same column used in create_centroids
# create a set of hexagon points for plotting
fort_hex <- fortify_hexagon(data = hex_allocated, sf_id = "LGA_CODE16", hex_size = 0.2)
# plot the hexagons
}
