% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functionsPlotting_base.R
\name{superbPlot.bar}
\alias{superbPlot.bar}
\title{superbPlot 'bar' layout}
\usage{
superbPlot.bar(
  summarydata,
  xfactor,
  groupingfactor,
  addfactors,
  rawdata = NULL,
  barParams = list(),
  errorbarParams = list(),
  facetParams = list(),
  xAsFactor = TRUE
)
}
\arguments{
\item{summarydata}{a data.frame with columns "center", "lowerwidth" and "upperwidth" for each level of the factors;}

\item{xfactor}{a string with the name of the column where the factor going on the horizontal axis is given;}

\item{groupingfactor}{a string with the name of the column for which the data will be grouped on the plot;}

\item{addfactors}{a string with up to two additional factors to make the rows and columns panels, in the form "fact1 ~ fact2";}

\item{rawdata}{always contains "DV" for each participants and each level of the factors}

\item{barParams}{(optional) list of graphic directives that are sent to the geom_bar layer}

\item{errorbarParams}{(optional) list of graphic directives that are sent to the geom_superberrorbar layer}

\item{facetParams}{(optional) list of graphic directives that are sent to the facet_grid layer}

\item{xAsFactor}{(optional) Boolean to indicate if the factor on the horizontal should continuous or discrete (default is discrete)}
}
\value{
a ggplot object
}
\description{
superbPlot comes with a few built-in templates for making the final plots.
All produces ggplot objects that can be further customized. Additionally, it is
possible to add custom-make templates (see vignette 6). The functions, to be
"superbPlot-compatible", must have these parameters:
}
\examples{
# This will make a plot with bars
superb(
   len ~ dose + supp, 
   ToothGrowth, 
   plotStyle="bar" 
)

# if you extract the data with superbData, you can 
# run this layout directly
#processedData <- superb(
#   len ~ dose + supp,
#   ToothGrowth, 
#   showPlot = FALSE
#)
#
#superbPlot.bar(processedData$summaryStatistic,
#   "dose",
#   "supp",
#   ".~.",
#   processedData$rawData)

}
