% Generated by roxygen2 (4.0.1): do not edit by hand
\name{dx}
\alias{dx}
\alias{dx.coxph}
\title{Diagnostics for \code{coxph} models}
\usage{
dx(x, ...)

\method{dx}{coxph}(x, ..., what = c("all", "ph", "lin", "inf"),
  toPdf = TRUE, file = "dxPlots.pdf", maxStrata = 5, defCont = 2,
  noQuantiles = 3, maxFact = 4, identify = FALSE, degfP = 3,
  degfRS = 4, degfSS = 4, timeTrans = c("km", "log", "rank", "identity"),
  ties)
}
\arguments{
\item{x}{An object of class \code{coxph}.}

\item{...}{Additional arguments. Can be passed to \code{graphics::plot}
or \code{graphics::matplot}.
\cr
See \code{?par} for details.}

\item{what}{Which plots to make. See \bold{Value} below.}

\item{toPdf}{Print plots to pdf. This is usually recommended as
each plot is created on a new device and 'R' can typically only
have 61 devices open simultaneously.
\itemize{
  \item If \code{toPdf=TRUE}, each plot is created on a new page.
  \item If \code{toPdf=FALSE}, each plot is created on a new screen device.
 }}

\item{file}{Filename to store plots. Default is \code{"dxPlots.pdf"}.}

\item{maxStrata}{Used for time vs. log-log survival plot.
\cr
If there are \eqn{>} \code{maxStrata} strata, no plot is shown for this.
\cr
Recommended is \eqn{\leq 5}{<=5} to prevent the plot from becoming visually cluttered.}

\item{defCont}{Definition of continuous variable.
\cr
Variables with more than \code{defCont} unique values will
be split into quantiles to facilitate graphs.
\cr
(This does \emph{not} apply to \code{factor} variables).}

\item{noQuantiles}{No. of quantiles into which to
split continuous variables}

\item{maxFact}{Maximum number of levels in a factor.
\cr
Used in plotting differences in log-hazard curves.}

\item{identify}{Identify outliers manually. Cannot be used with \code{toPdf=TRUE}.}

\item{degfP}{Degrees of freedom for smoothing spline in Poisson model.}

\item{degfRS}{Degrees of freedom for regression splines.}

\item{degfSS}{Degrees of freedom for smoothing splines.
If \code{degFSS=0}, the 'optimal' degrees of freedom is chosen
according to the \code{\link{AIC}}.}

\item{timeTrans}{Type of time transformation to use when refitting model with
time-transformed covariate.
\cr
See \code{?survival::cox.zph} for details.}

\item{ties}{Method of handling ties when refitting model (for stratified plots).
\cr
Default is the same as the original model, \code{x}.
Usually one of \code{"breslow"} or \code{"efron"}.}
}
\value{
Plots with base graphics.
\cr
If \code{what="ph"}:
  \item{\eqn{\pm}{+-}}{Time vs. \eqn{-\log -\log}{-log-log} survival.
                         \cr
                         If not too many strata to plot, as per argument \code{maxStrata}.}
  \item{*}{Quantile-quantile plot.
           \cr
           Unit exponential distribution
           vs. expected events (or Cox-Snell residuals)}
  \item{*}{Observed vs. expected hazard}
  \item{*}{Expected events vs. hazard based on sorted expected events}
  \item{*}{Time vs. hazard, per predictor.
           \cr
           Continuous variables are split into quantiles.}
  \item{*}{Time vs. difference in log hazards, per predictor.
           \cr
           Continuous variables are split into quantiles.}
  \item{*}{Reference hazard vs. hazard for predictor.
           \cr
           Continuous variables are split into quantiles.}
If \code{what="lin"} (only applies to continuous variables):
  \item{\eqn{\pm}{+-}}{Predictor vs. residuals from a Poisson model with smoothing spline.}
  \item{\eqn{\pm}{+-}}{Predictor vs. partial residual for predictor (with regression spline).
                       \cr
                       For predictors with \eqn{>} \code{degfRS}. }
  \item{\eqn{\pm}{+-}}{Predictor vs. partial residual for predictor (with smoothing spline).
                       \cr
                       For predictors with \eqn{>} \code{degfSS}.}
  \item{*}{Time vs. scaled Schoenfeld residuals, per predictor.}
If \code{what="inf"}:
  \item{*}{Observation vs. jacknife influence.}
  \item{*}{Observation vs. jacknife influence (scaled by standard error of coefficients).}
  \item{*}{Observation vs. leverage (=scaled score residual).}
  \item{*}{Martingale residuals vs. likelihood displacement residuals.}

If \code{what="lin"}, a \code{list} of \code{data.table}s is also returned to the console:

  \item{Poisson}{Results from anova for a Poisson fit (via \code{gam}) with nonparametric effects.
                 \cr
                 The model is re-fit with smoothing splines for continuous variables.
                 \cr
                 Needs at least one predictor to have \eqn{>3} unique values.}
  \item{tt}{Results from the time-transformed fit, using \code{survival::cox.zph}.}
}
\description{
Diagnostics for \code{coxph} models
}
\note{
\bold{TESTS OF PROPORTIONAL HAZARDS}
\cr \cr
A simple graphical test of proportional hazards, applicable to time-fixed
variables with a small number of levels, is a plot of
time vs. \eqn{-\log (-\log [\hat{S}(t)])}{-log(-log[S(t)])}.
\cr
The Kaplan-Meier curves should be parallel as:
\deqn{\hat{S}_i(t) = \exp -H_i(t) = \exp[-(H_0(t) \exp[\hat{\beta} X_i(t)])]}{
       S[i](t) = exp(-H[i](t)) = exp(- H[0](t).exp( B.X[i](t) ) )}
where \eqn{H_0(t)}{H[0](t)} is the Breslow's estimator of the baseline hazard
(i.e. all co-variates are zero),
often represented as \eqn{\lambda_0(t)}{lambda[0](t)}. Thus
\deqn{-\log (-\log [\hat{S}(t)]) = -\log(H_0(t)) - \hat{\beta} X_i(t)}{
      -log(-log[S(t)]) = -log(H[0](t)) - B.X[i]}

\subsection{A note on Cox-Snell residuals}{
  Given \eqn{n} observations, the residuals are:
  \deqn{ \hat{M}_i = Y_i - E(Y_i), \quad i=1,...,n }{
         M[i] = Y[i] - E(Y[i]) }
  where \eqn{Y_i}{Y[i]} are the observed events,
  \eqn{E(Y_i)}{E(Y[i])} are the expected events and
  \eqn{\hat{M}_i}{M[i]} is the vector of residuals, known as \bold{martingale} residuals.
  \cr
  The expected events \eqn{E(Y_i)}{E(Y[i])} are generated for each observation as
  \deqn{E(Y_i) = H_0(t) \exp \sum \hat{\beta} X_i(t)}{
        E(Y[i]) = H[0](t) exp( SUM B.X[i](t) )}
  The equation for these residuals may be rewritten as:
  \deqn{ E(Y_i) = Y_i - \hat{M}_i, \quad i=1,...,n }{
         E(Y[i]) = Y[i] - M[i], for i=1 to n}
  Somewhat unintuitively, these predicted values \eqn{E(Y_i)}{E(Y[i])}, are also known as the
  \bold{Cox-Snell} residuals.
}

These Cox-Snell residuals are used to assess the fit of a
proportional hazards model.
More formally, they are are generated from the (non time-dependent)
covariates \eqn{X}, a matrix
with one row per observation (total \eqn{n}) and additional indicators
of time \eqn{t} and status \eqn{\delta}{D}.
The estimated coefficients are \eqn{ \hat{\beta} }{B},
where \eqn{\hat{\beta}}{B} is a vector of length \eqn{p} (the number of predictors).
\cr
The residuals are:
\deqn{r_i = H_0(t_i) \exp \sum_{k=1}^p \hat{\beta_k}X_{ik}(t_i),\quad i=1,...,n,\quad k=1,...,p}{
       r[i] = H[0](t[i]) exp ( SUM B[k].X[ik](t[i]) ), for j=1 to n, k=1 to p}
If the coefficients are close to their true values, then \eqn{r_i}{r[i]}
should follow a unit-exponential distribution, i.e. \eqn{H_0(t) \approx t}{H[0](t) = t}.
\cr \cr
Thus a \code{qqplot} of \eqn{r_i}{r[i]} against a unit-exponential distribution
is given. This is of limited value, as the \emph{null} model (no coefficients) will be
closer to the true exponential distribution than that with \emph{any} coefficients.
\cr \cr
Another simple graphical test is a plot of observed vs. expected values
for the cumulative hazard.
\cr
The expected values of the hazard are generated using the expected events
(using \code{\link{as.Surv}}).
This should follow a straight line through the origin with a slope of \eqn{1}.
\cr \cr
To check if the coefficients are close to their true values,
we can compute the Nelson-Aalen estimator of the
cumulative hazard rate of the \eqn{r_i}{r[i]}'s. A plot of this
estimator against \eqn{r_i}{r[i]} should be a straight line
through the origin with a slope of \eqn{1}.
\cr \cr
Continuous predictors are split into quantiles to facilitate the following plots:
\itemize{
  \item Plots of time vs. cumulative hazard, per predictor,
        should be a constant multiples of a baseline hazard, i.e. parallel.
  \item Plots of time vs. difference in log hazards, per predictor,
        should be constant over time i.e. parallel.
        \cr
        The difference should be close to \eqn{0}.
  \item Plots of hazard vs. reference group, per predictor,
        should be linear with a slope of 45 degrees.
}

\bold{Discretizing a continuous variable}
\cr \cr
These methods work by stratifying a covariate \eqn{K} into
\eqn{q} disjoint quantiles or groups \eqn{g}.
A stratified \code{coxph} model is fitted to these
quantiles and one is selected as a reference.
\cr
The \bold{cumulative hazard} \eqn{\hat{H}_g(t)}{H[g](t)} is
plotted for each group \eqn{g}.
These should be a constant multiple of the reference stratum
\eqn{\hat{H}_1(t)}{H[1](t)} over time.
\cr \cr
A simpler way to compare these is to plot the
\bold{differences in log cumulative hazard}, that is:
\deqn{\log \hat{H}_g(t) - \log \hat{H}_1(t), \quad g = 2,...,q}{
       log(H[1](t)) - log(H[g](t)) for g = 2 to q}
Each curve should be horizontal and constant over time.
\cr
Curves above zero indicate
an increase in hazard in group \eqn{g} vs. the reference at that time.
\cr \cr
\bold{Andersen plots} show \eqn{\log \hat{H}_1(t)}{log(H[1](t))}
vs. \eqn{\log \hat{H}_g(t), \quad g = 2,...,q}{
         log(H[g](t)) , g = 2 to K}.
\cr
If proportional hazards are present, these should be straight lines through
the origin.
\cr
If the curve is convex (towards the upper left of the plot) this shows that
\eqn{ \hat{H}_g(t) \div \hat{H}_1(t)}{
       H[g](t) / H[1](t)}
is an increasing function of \eqn{t}{time}.
Thus if convex, the hazard rate in group \eqn{g} is
increased vs. the reference, group \eqn{1}.
\cr \cr
A model with \bold{time-dependent coefficients} should not vary from one
without such coefficients if the assumption of proportional-hazards is met. That is, making
the coefficient a function of time,
\eqn{\hat{\beta}_k \rightarrow f(\hat{\beta}_k, t)}{
     B[k] --> f(B[k], t)}
and plotting this against time \eqn{t} should give a horizontal line.
\cr
To test this we plot the \emph{scaled Schoenfeld residuals} against time.
These are
\deqn{s^*_i = V^{-1}(\hat{\beta}, t_i)s_i}{
      s*[i] = INVERSE(Var(B, t)) . s[i]}

\subsection{A note on generating Schoenfeld residuals}{
  These are based on the contribution of each observation to
  the derivative of the log partial likelihood.
  \cr
  They are defined for each time where an event occurs and have a value
  for each coefficient \eqn{\hat{\beta}_k}{B[k]}. They are given by:
  \deqn{s_{ik} = X_{ik} - \bar{x}_k, \quad i=1,...,n \quad k=1,...,p}{
        s[i,k] = X[i,k] - x[k] for i=1 to n, k=1 to p}
  Here, \eqn{\bar{x}_k}{x[k]} is the mean of those still at risk for covariate \eqn{k}.
  \cr
  This is a weighted mean of the values of \eqn{X_k}{X[k]}
  (for cofficient \eqn{k}):
  \deqn{\bar{x}_k = \frac{\sum W X_i}{\sum W}}{
        x[k] = SUM W.X[i] / SUM W}
  and the weights are:
  \deqn{W = \exp \hat{\beta} X_i}{
        W = exp( B.X[i] )}
  where \eqn{X_i}{X[i]} refers to those still at risk at time \eqn{t_i}{t[i]}.
  \cr
  Now the inverse of the variance of \eqn{s_{ik}}{s[ik]} is approximately:
  \deqn{V^{-1} \approx Y\hat{V(\beta)}}{
        INVERSE(Var) = Y.Var(B)}
  where \eqn{Y} is the number of events and \eqn{\hat{V(\beta)}}{Var(B)} is the covariance
  matrix of the estimated coefficients.
}

Given the above
\deqn{E(s^*_i) + \hat{\beta}_k \approx \hat{\beta}_k(t_i)}{
      E(s*[i]) + B[k] = B(k)(t[i])}
so that a plot of time vs. \eqn{s^*_i} should be horizontal.
\cr \cr
\bold{TESTS OF LINEARITY FOR CONTINUOUS VARIABLES}
\cr \cr
The \bold{martingale} residual is used to help determine the best
functional
form of a covariate in a \code{coxph} model.
As above, the Cox model assumes that the hazard function satisfies:
\deqn{H_{i}(t) = H_0(t) \exp{X_i\hat{\beta}}}{
       H[i](t) = H[0](t) exp (X[i].B)}
That is, for a continuous variable,
a unit increase in the variable produces the same
change in risk across the value of the variable.
(E.g. an increase in age of 5 years leads to the same
change in hazard, no matter what the increase is from or to).
\cr
To verify this is the case, a null model is fitted
(i.e no coefficients, similar to intercept-only model in linear regression).
Martingale residuals are calcuated for this.
\cr
Plots of these residuals against the values of each of the
predictors in the model are shown.
If the correct model for covariate \eqn{k}
is based on a smooth function \eqn{f()}, i.e.
\eqn{ \exp(f(X_k)\hat{\beta_k)}}{
       exp(f(X[k]).B[k])}
then the following should hold:
\deqn{E(M_i | X_{ik}=X_k) \approx c.f(X_k)}{
      E( M[i] | X[ik]=X[k] ) = c.f(X[k])}
Where \eqn{M_i}{M[i]} is the martingale residual and
the constant \eqn{c} depends
on the amount of \bold{c}ensoring and is
roughly independent of \eqn{X_k}{X[k]}.
\cr
A \code{lowess} smoothed line is added to the plot.
This should be approximately linear if the
assumption of proportional hazards is met.
If the plot shows a sharp threshold, a discretised version of the covariate
may be preferable.
\cr \cr
\bold{Poisson} regression models \emph{are also} proportional hazards
models. The Cox model may thus be rewritten in Poisson form to allow
for application of residual methods applicable to Poisson regression.
\cr
The Cox model can be written as:
\deqn{H_i(t) = \exp(f(x) \hat{\beta} H_0(t))}{
      H[i](t) = \exp( f(x)B.H[0](t) )}
And the standard Poisson model can be written as:
\deqn{ E(Y_i|X) = \exp X_iT}{
       E( Y[i] | X ) = exp( X[i].T )}
where \eqn{Y_i}{Y[i]} are the observed events and
\eqn{T} is the observation time (often referred to as \eqn{\theta}{theta}).
This is thus:
\deqn{E(Y_i|X) = \exp( (f(X_i) \hat{\beta}) \int_0 Y_i(t) H_0(t) dt)}{
      E( Y[i] | X ) = exp( (f(X[i]).B) . INTEGRAL Y[i](t).H[0](t) dt )}
Where \eqn{T = \int_0 Y_i(t) H_0(t) dt}{T = INTEGRAL Y[i](t).H[0](t) dt}.
Once expressed as a Poisson model, this can be analysed using tools
available for generalized additive models (\code{gam}).
\cr
To do this the \code{coxph} model is refit with \code{gam}. The
outcome (left-hand side) is those times in which an event occurred.
The predictors are the same. For continuous terms, an attempt is
made to fit a non-linear function to improve the fit, with a default
of \eqn{4} degrees of freedom (\code{degfP=4}).
\cr
The Poisson model fit with \code{gam} has an additional \code{offset}
term. This is
\deqn{\texttt{offset} = \log[ \exp(-X_i\hat{\beta}) \exp(X_i\hat{\beta}H_0(t_i))]
             = H_0(t_i)
             \approx  \int_0 Y_i(t)H_0(t) dt}{
offset = log( exp(-X[i].B) . exp(X[i].B.H[0](t)) ) = INTEGRAL Y[i](t)H[0](t) dt }
See \code{?predict.coxph} for details.
Plots and anova are generated (see \code{?anova.gam} for details).
Plots show the residuals by the values of the predictor.
Ideally these should be horizontal with the intercept at zero.
\cr \cr
\bold{Regression splines} may be used to replace continuous terms
directly in the \code{coxph} function.
These are fit by connecting number of knots with locally fitting curves.
The degrees of freedom (by default \code{degfRS=4}) is the number of knots plus one.
\code{degfRS} \eqn{-1} dummy variables are generated to try to improve the
fit of the variable. Plots of the original variable vs. the fitted splines
should be linear. The function uses B-splines.
\cr \cr
\bold{Penalized smoothing splines} are an alternative to
regression splines which, for small degrees of freedom, have better
properties regarding their locality of influence.
They are chosen to minimize \eqn{\beta}{B} for the basis functions, in:
\deqn{ \theta \sum_{i=1}^n [y_i -f(x_i, \beta)]^2 +
         (1-\theta) \int [f''(x,\beta)]^2 dx }{
       T . SUM [y - f(x, B)]^2 + (1-T) . INTEGRAL [f''(x, B)]^2 dx}
Here the first term is the residual sum of squares and the
second is the integral of the second derivative of the function \eqn{f}
with respect to \eqn{x}.
\cr
For a straight line \eqn{f''(x)=0} and the term will increase in
proportion to the degree of curvature.
\eqn{\theta}{T} is a \bold{t}uning parameter based on the degrees of freedom
(by default \code{degfSS=4}).
As \eqn{\theta \rightarrow 0}{T approaches zero}
(\eqn{2} degrees of freedom, including intercept),
the solution converges to the least-squares line.
As \eqn{\theta \rightarrow 1}{T approaches one}, (\eqn{n} degrees of freedom),
the solution approaches a curve that passes through each point.
Plots of the fitted splines vs. the original variable
should be linear.
\cr \cr
\bold{TESTS OF INFLUENCE}
\cr \cr
The simplest measure of influence is the \bold{jackknife} value
\deqn{J_i=\hat{\beta} - \hat{\beta}_{-i}}{
      J[i] = B - B[-i]}
where \eqn{\beta_{-i}}{B[-i]} is the result of a fit that includes all
observations except \eqn{i}. This can be computed as
\itemize{
 \item Converge to \eqn{\hat{\beta}}{B} as usual e.g. via Newton-Raphson.
 \item Delete observation \eqn{i}.
 \item Perform one additional iteration.
}
This may be expressed as:
\deqn{\delta \beta = 1'(U \chi^{-1}) = 1'D}{
      change in B = 1'(U.INVERSE(Var(B))) = 1'D}
Here \eqn{D}, the matrix of \bold{dfbeta residuals}, is comprised of
the score residuals \eqn{U} scaled by the variance of \eqn{\beta}{B},
\eqn{var(B)}{Var(B)}. Each row of \eqn{D} is the change in \eqn{\hat{\beta}}{B} if
observation \eqn{i} is removed.
\cr \cr
Caution - for plots to verify proportional hazards:
the variance of the curves is not constant over time.
Increasing departures from model assumptions are likely to be found
as time increases.
\code{package:surv2sample} may need to be installed from source
to allow one of the examples to run.
}
\examples{
\dontrun{
### running these examples with toPdf=FALSE will
### open too many devices to be compatible with R CMD check
### results from these examples can be found in the package source
### under /survMisc/inst/doc/
###
### for log-log plot
if(require(devtools)){
### this package is now archived, so need to install from url
 install_url("http://cran.r-project.org/src/contrib/Archive/surv2sample/surv2sample_0.1-2.tar.gz")
     library(surv2sample)
     data(gastric, package="surv2sample")
     dx(coxph(Surv(time/365, event) ~ treatment, data=gastric), file="gasDx.pdf")
 }
data(bmt, package="KMsurv")
bmt <- within(bmt, {
z1 <- z1 -28
z2 <- z2- 28
z3 <- z1*z2
z4 <- as.double(group == 2)
z5 <- as.double(group == 3)
z6 <- z8
z7 <- (z7 / 30) - 9
z8 <- z10
})
c1 <- coxph(Surv(t2, d3) ~ z1 + z2 + z3 + z4 + z5 + z6 + z7 + z8,
         method="breslow", data=bmt)
dx(c1, file="bmtDx.pdf")
###
data(alloauto, package="KMsurv")
c1 <- coxph(Surv(time,delta) ~ factor(type),
            method="breslow", data=alloauto)
dx(c1, file="alloDx.pdf")
### GAM model. Therneau 5.3
data(pbc, package="survival")
w1 <- which(is.na(pbc$protime))
pbc <- pbc[-w1, ]
c1 <- coxph(Surv(time, status==2) ~ age + edema + bili + protime + albumin,
            data=pbc, method="breslow")
dx(c1, file="pbcDx.pdf")
### Time dependent covariate. Therneau 6.3
data(veteran, package="survival")
veteran$celltype <- relevel(veteran$celltype, ref="adeno")
c1 <- coxph(Surv(time, status) ~ trt * celltype + karno + diagtime + log(age) + prior,
            data=veteran[-1, ])
dx(c1, what="ph", file="vetDx.pdf")
}
### simple example which doesn't take up too many devices
c1 <- coxph(formula = Surv(time, status == 2) ~ age + log(bili), data=pbc)
dx(c1)
}
\references{
Examples are from
\bold{K&M} Example 11.1 - 11.7, pg 355--66.

Last example is from:
Therneau T, Grambsch P 2000.
\emph{Modeling Survival Data}, 1st edition.
New York: Springer.
Section 5.1.2, pg 91.
\href{http://dx.doi.org/10.1007/978-1-4757-3294-8}{Springer (paywall)}

Andersen PK, Borgan O, Gill R, Keiding N 1982.
Linear Nonparametric Tests for Comparison of Counting Processes, with
Applications to Censored Survival Data, Correspondent Paper.
\emph{International Statistical Review} \bold{50}(3):219--44.
\href{http://www.jstor.org/stable/1402489}{JSTOR}
}

