% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmst2adapt-ver001.R
\docType{package}
\name{survRM2adapt-package}
\alias{survRM2adapt-package}
\title{Flexible and Coherent Test/Estimation Procedure Based on Restricted Mean Survival Times}
\description{
Performs the procedure proposed by Horiguchi et al. (2018) <doi:10.1002/sim.7661>.
The method specifies a set of truncation time points tau's for calculating restricted mean survival times (RMST),
performs testing for equality, and estimates the difference in RMST between two groups at the specified tau's.
Multiplicity by specifying several tau's is taken into account in this procedure.
}
\examples{
#--- sample data ---#
data    = rmst2adapt.sample.data()
nmethod = 100 #This is only for example use.
              #Recommended to specify at least 100000 (default) or larger.

a = rmst2adapt(indata=data, tau_star=seq(6,12,2), method="perturbation",
               nmethod=nmethod, test="2_side")
print(a)
}
\references{
Horiguchi M, Cronin A, Takeuchi M, Uno H. A flexible and coherent test/estimation procedure based on restricted mean survival times for censored time-to-event data
in randomized clinical trials. Statistics in Medicine 2018. doi:10.1002/sim.7661.
}
\seealso{
survival survRM2
}
\author{
Miki Horiguchi, Hajime Uno

Maintainer: Miki Horiguchi <horiguchimiki@gmail.com>
}
\keyword{survival}
