% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMatrix.R
\name{plotMatrix}
\alias{plotMatrix}
\title{Plots a color matrix.}
\usage{
plotMatrix(colorMatr, borderCol, coordX, coordY, widthX, widthY)
}
\arguments{
\item{colorMatr}{A matrix of colors in R format.}

\item{borderCol}{The border color of plotted rectangles.}

\item{coordX}{X coordinate of the lower left corner of \code{colorMatr}.}

\item{coordY}{Y coordinate of the lower left corner of \code{colorMatr}.}

\item{widthX}{The vector of lengths of the rectangle sides parallel to the X-axis. The length of \code{widthX} can be either 1 (all rectangles have the same side length for X-axis) or the number of columns of \code{colorMatr}}

\item{widthY}{The vector of lengths of the rectangle sides parallel to the Y-axis. The length of \code{widthY} can be either 1 (all rectangles have the same side length for Y-axis) or the number of rows of \code{colorMatr}}
}
\value{
None
}
\description{
Plots a matrix of colors at a given point. Each element of the color matrix is plotted as a rectangle with user specified side lengths and border color.
}
\details{
\code{R}-function \code{plot()} has to be called first. The function plots a color matrix at a given coordinate. Each element of the color matrix is plotted as a rectangle with user specified border color and side lengths on X- and Y-axes. Element \code{colorMatr[nrow(colMatr), 1]} is displayed as the bottom left rectangle. Element \code{colorMatr[1, ncol(colMatr)]} is displayed as the top right rectangle.
}
\examples{
### Uneven rectangles
colorMatr = matrix(c("goldenrod1", "mediumpurple3", "palegreen3",
   "royalblue1", "orchid", "firebrick1"), nrow = 2, byrow = TRUE)
plot(c(1, 4), c(2, 4), type = "n", xlab = "", ylab = "")
plotMatrix(colorMatr, borderCol = "white", coordX = 1, coordY = 2,
   widthX = c(1/4, 1, 1/6), widthY = c(1, 1/2))
   
### Plotting the legend:
reshapeColMatr = matrix(t(colorMatr), ncol = 1, nrow = nrow(colorMatr)*ncol(colorMatr),
   byrow = TRUE)
plotMatrix(reshapeColMatr, borderCol = "white", coordX = 2.8, coordY = 2,
   widthX = c(1/4), widthY = c(1/4))
text(x = rep(3.03, nrow(reshapeColMatr)),
   y = 2.12+c(0,cumsum(rep(1/4, nrow(reshapeColMatr)-1))),
   labels = reshapeColMatr[nrow(reshapeColMatr):1], pos = 4, cex = 0.7)
   
### Same length and width rectangles on the black background
plot(c(1, 4), c(2, 4), type = "n", xlab = "", ylab = "")
polygon(x = c(0, 5, 5, 0, 0), y = c(0, 0, 5, 5, 0), col = "black")
plotMatrix(colorMatr, borderCol = "black", coordX = 1, coordY = 2, widthX = 1, widthY = 1)

}
\author{
Svetlana K Eden, \email{svetlanaeden@gmail.com}
}
\keyword{color}
\keyword{matrix}
