% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_shap.R
\name{surv_shap}
\alias{surv_shap}
\title{Helper functions for \code{predict_parts.R}}
\usage{
surv_shap(
  explainer,
  new_observation,
  ...,
  y_true = NULL,
  calculation_method = "kernel",
  aggregation_method = "integral",
  path = "average",
  B = 25,
  exact = FALSE
)
}
\arguments{
\item{explainer}{an explainer object - model preprocessed by the \code{explain()} function}

\item{new_observation}{a new observation for which predictions need to be explained}

\item{...}{additional parameters, passed to internal functions}

\item{y_true}{a two element numeric vector or matrix of one row and two columns, the first element being the true observed time and the second the status of the observation, used for plotting}

\item{calculation_method}{a character, only \code{"kernel"} is implemented for now.}

\item{aggregation_method}{a character, either \code{"mean_absolute"} or \code{"integral"}, \code{"max_absolute"}, \code{"sum_of_squares"}}

\item{path}{ignored, placeholder the not implemented \code{"sampling"} method}

\item{B}{ignored, placeholder the not implemented \code{"sampling"} method}

\item{exact}{ignored, placeholder the not implemented \code{"sampling"} method}
}
\value{
A list, containing the calculated SurvSHAP(t) results in the \code{result} field
}
\description{
Helper functions for \code{predict_parts.R}
}
\section{References}{

\itemize{
\item [1] Krzyziński, Mateusz, et al. \href{https://arxiv.org/abs/2208.11080}{"SurvSHAP(t): Time-dependent explanations of machine learning survival models."} arXiv preprint arXiv:2208.11080 (2022).
}
}

\keyword{internal}
