% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcoxfunctional.R
\name{ggcoxfunctional}
\alias{ggcoxfunctional}
\alias{print.ggcoxfunctional}
\title{Functional Form of Continuous Variable in Cox Proportional Hazards Model}
\usage{
ggcoxfunctional(formula, data = NULL, fit, iter = 0, f = 0.6,
  point.col = "red", point.size = 1, point.shape = 19, point.alpha = 1,
  xlim = NULL, ylim = NULL,
  ylab = "Martingale Residuals \\nof Null Cox Model", title = NULL,
  caption = NULL, ggtheme = theme_survminer(), ...)

\method{print}{ggcoxfunctional}(x, ..., newpage = TRUE)
}
\arguments{
\item{formula}{a formula object, with the response on the left of a ~ operator, and the terms on the right. The response must be a survival object as returned by the \link{Surv} function.}

\item{data}{a \code{data.frame} in which to interpret the variables named in the formula,}

\item{fit}{an object of class \link{coxph.object} - created with \link{coxph} function.}

\item{iter}{parameter of \link{lowess}.}

\item{f}{parameter of \link{lowess}.}

\item{point.col, point.size, point.shape, point.alpha}{color, size, shape and visibility to be used for points.}

\item{xlim, ylim}{x and y axis limits e.g. xlim = c(0, 1000), ylim = c(0, 1).}

\item{ylab}{y axis label.}

\item{title}{the title of the final \link{grob} (\code{top} in \link{arrangeGrob})}

\item{caption}{the caption of the final \link{grob} (\code{bottom} in \link{arrangeGrob})}

\item{ggtheme}{function, ggplot2 theme name. Default value is \link{theme_classic2}.
Allowed values include ggplot2 official themes: see \code{\link[ggplot2]{theme}}.}

\item{...}{further arguments passed to the function \code{\link[ggpubr]{ggpar}} for customizing the plot.}

\item{x}{an object of class ggcoxfunctional}

\item{newpage}{open a new page. See \code{\link{grid.arrange}}.}
}
\value{
Returns an object of class \code{ggcoxfunctional} which is a list of ggplots.
}
\description{
Displays graphs of continuous explanatory variable against martingale residuals of null
cox proportional hazards model, for each term in of the right side of \code{formula}. This might help to properly
choose the functional form of continuous variable in cox model (\link{coxph}). Fitted lines with \link{lowess} function
should be linear to satisfy cox proportional hazards model assumptions.
}
\section{Functions}{
\itemize{
\item \code{ggcoxfunctional}: Functional Form of Continuous Variable in Cox Proportional Hazards Model.
}}

\examples{

library(survival)
data(mgus)
res.cox <- coxph(Surv(futime, death) ~ mspike + log(mspike) + I(mspike^2) +
    age + I(log(age)^2) + I(sqrt(age)), data = mgus)
ggcoxfunctional(res.cox,  data = mgus, point.col = "blue", point.alpha = 0.5)
ggcoxfunctional(res.cox, data = mgus, point.col = "blue", point.alpha = 0.5,
                title = "Pass the title", caption = "Pass the caption")


}
\author{
Marcin Kosinski , \email{m.p.kosinski@gmail.com}
}
