% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_surv_prob.R
\name{get_surv_prob}
\alias{get_surv_prob}
\title{Get Survival Probability at Specified Times}
\usage{
get_surv_prob(fit, times)
}
\arguments{
\item{fit}{survival::survfit object.}

\item{times}{Vector of times to lookup survival probabilities.}
}
\value{
Vector of survival probabilities based on the input times.
}
\description{
\code{get_surv_prob} retrieves the survival probability at a specific time
from a survival curve object from the survival::survfit function. The
survival curve object can only have one group.
}
\examples{
library("survival")

# Get Survival Probabilities Based on Whole Cohort
fit <- survfit(Surv(time, status) ~ 1, data = colon)
times <- c(100, 200, 300)
get_surv_prob(fit, times)

# Get Survival Probabilities for Each rx Group
library("purrr")
library("dplyr")
library("tidyr")

surv.prob.res <- 
  colon \%>\%
  split(.$rx) \%>\%
  map(~ survfit(Surv(time, status) ~ 1, data = .)) \%>\%
  map(get_surv_prob, times)

surv.prob.res.df <- as_data_frame(surv.prob.res)
colnames(surv.prob.res.df) <- names(surv.prob.res)
surv.prob.res.df <-
  surv.prob.res.df \%>\%
  mutate(surv_prob_time = times)

gather(surv.prob.res.df, "group", "surv_prob", Obs:`Lev+5FU`)
}

