% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_response.R
\name{variable_response}
\alias{variable_response}
\title{Variable response for survival models}
\usage{
variable_response(explainer, variable, type = "pdp",
  link = explainer$link, ...)
}
\arguments{
\item{explainer}{an object of the class 'surv_explainer'.}

\item{variable}{a character with variable name.}

\item{type}{a character - type of the response to be calculated.
Currently following options are implemented: 'pdp' for Partial Dependency.}

\item{link}{a function - a link function that shall be applied to raw model predictions. This will be inherited from the explainer.}

\item{...}{other parameters}
}
\description{
Function \code{variable response} calculates the expected output condition on a selected variable.
}
\examples{
\donttest{
library(survxai)
library(rms)
data("pbcTest")
data("pbcTrain")
predict_times <- function(model, data, times){
                  prob <- rms::survest(model, data, times = times)$surv
                  return(prob)
                  }
cph_model <- cph(Surv(years, status)~., data=pbcTrain, surv=TRUE, x = TRUE, y=TRUE)
surve_cph <- explain(model = cph_model, data = pbcTest[,-c(1,5)], 
             y = Surv(pbcTest$years, pbcTest$status), predict_function = predict_times)
svr_cph <- variable_response(surve_cph, "sex")
}
}
