% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swdft.R
\name{swdft}
\alias{swdft}
\title{Sliding Window Discrete Fourier Transform (SWDFT)}
\usage{
swdft(x, n, type = "fftw", normalize = 1)
}
\arguments{
\item{x}{real or complex vector}

\item{n}{integer window size.}

\item{type}{algorithm to implement. defaults to "fftw"}

\item{normalize}{how to scale SWDFT coefficients. Defaults
to unnormalized (1), but many definitions include either
(1 / n) or (1 / sqrt(n))}
}
\value{
n x P array, where P = length(x) - n + 1
}
\description{
Sliding Window Discrete Fourier Transform (SWDFT)
}
\examples{
x <- rnorm(n = 20)
a <- swdft(x, n = 2^3)


}
