% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress_image.R
\name{progress_image}
\alias{progress_image}
\title{Display a custom 80 by 80 pixel image as a progress bar.}
\arguments{
\item{eavesdrop}{The variable to track with a progress bar.}

\item{maximum}{The maximum value of \code{eavesdrop} that marks the end of
what to progress track.}

\item{size}{A number used to designate the size (magnification) of the
widget. The default is set to \code{1} which is 80 by 80 pixels. For
example, setting to \code{3} will results in a widget 3-times the default
size (240 by 240 pixels) and will occupy a grid area of 3 by 3.}

\item{placeOnGrid}{A row by column coordinate (e.g., \code{c(row-number, column-number)})
of a grid that designates the position to draw the widget on the
\code{switchboard}. Use \code{showGrid()} to help organize widget placement
on dashboard. The default places the first widget in pipe chain to
the \code{c(1, 1)} position, and all following on the same row stacked to
the right.}

\item{updates}{The number of times the widget is to be updated (e.g., when
it be modified/changed). The default updates the widget 100 times. Increase
number for smoother progress bar animation.}

\item{delay}{Pause each update of the switchboard. Default has no delay,
values are in seconds (e.g., \code{delay = 0.01} results in 0.01 second
delay with each iteration).}

\item{honest}{When \code{TRUE}, it updates the widget by the true progression value.
 The default (\code{FALSE}) has a cosmetic modification to the progression
value that helps update it in a prettier way.}

\item{closeAtMaximum}{Functions like \code{switchboard_close()} by closing
the switchboard window when the eavesdropped value equals maximum. NOTE:
if a widget has \code{closeAtMaximum = TRUE}, then this widget MUST
be placed at the end (i.e., last widget) of the pipe chain.}

\item{fill}{The direction of how things are animated when displaying
progression. The default is \code{horizontal}, which tracks progression
from left to right (maximum), but \code{vertical} can also be used for progress to
occur in a bottom to up (maximum) animation.}

\item{file}{A *.png filename with a transparent background that designates an
image to be used as a progress-bar. The total image size should be
80 by 80 pixels, but for best integration into switchboard layout, the
actual image must be 75 by 75 pixels placed at the bottom left of the
80 by 80 image. This will leave a 5 pixel whitespace at both the top
and right side of the image.}
}
\value{
Nothing.
}
\description{
The \code{progress_image} widget displays an image as a progressBar.
}
\section{Usage}{

   \preformatted{progress_image(eavesdrop, maximum = 100, size = 1,
   placeOnGrid = c(1, 1), updates = 100, delay = 0, honest = FALSE,
   closeAtMaximum = FALSE, fill = "horizontal", file = "")}
}

\examples{
\dontrun{
     
     for (i in 1:250) {
       switchboard(delay = 0.01) \%>\%
         progress_image(i, maximum = 250, 
                        file = system.file("images", "topography.png", package = "switchboard"))
     }
     switchboard_close()

}

}
\seealso{
Other progress bars: 
\code{\link{progress_benchmark}()},
\code{\link{progress_ibis}()},
\code{\link{progress_oyster}()},
\code{\link{progress_percent}()},
\code{\link{progress_phyllotaxis}()},
\code{\link{progress_pikachu}()},
\code{\link{progress_ring_percent}()},
\code{\link{progress_ring}()}
}
\concept{progress bars}
