/*
 * Decompiled with CFR 0.152.
 */
package sample;

import blbutil.Utilities;
import haplotype.HapPair;
import haplotype.RevHapPair;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import main.GenotypeValues;
import sample.HapBaum;

public class ProduceHapSamples
implements Runnable {
    public static final Integer POISON = -1;
    private final boolean markersAreReversed;
    private final HapBaum baum;
    private final BlockingQueue<Integer> qIn;
    private final List<HapPair> sampledHaps;
    private final GenotypeValues gv;
    private final double[] gprobs;

    public ProduceHapSamples(boolean bl, HapBaum hapBaum, BlockingQueue<Integer> blockingQueue, List<HapPair> list, GenotypeValues genotypeValues) {
        if (hapBaum == null) {
            throw new NullPointerException("baum=null");
        }
        if (blockingQueue == null) {
            throw new IllegalArgumentException("qIn==null");
        }
        if (list == null) {
            throw new IllegalArgumentException("hapList==null");
        }
        if (genotypeValues == null) {
            throw new IllegalArgumentException("gv==null");
        }
        this.markersAreReversed = bl;
        this.baum = hapBaum;
        this.qIn = blockingQueue;
        this.gv = genotypeValues;
        this.sampledHaps = list;
        this.gprobs = new double[genotypeValues.markers().sumGenotypes()];
    }

    @Override
    public void run() {
        try {
            int n = this.qIn.take();
            while (n != POISON) {
                List<HapPair> list = this.baum.randomSample(n, this.gprobs);
                this.storeHaps(list);
                this.gv.add(n, this.gprobs);
                n = this.qIn.take();
            }
        }
        catch (Throwable throwable) {
            Utilities.exit("ProduceHapSamples: ERROR", throwable);
        }
    }

    private void storeHaps(List<HapPair> list) {
        if (this.markersAreReversed) {
            for (HapPair hapPair : list) {
                this.sampledHaps.add(new RevHapPair(hapPair));
            }
        } else {
            this.sampledHaps.addAll(list);
        }
    }
}

