/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

public class IndexSet {
    private final boolean[] inSet;
    private final int[] indices;
    private int size = 0;

    public IndexSet(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maxIndex<0: " + n);
        }
        this.inSet = new boolean[n + 1];
        this.indices = new int[n + 1];
    }

    public boolean add(int n) {
        if (!this.inSet[n]) {
            this.indices[this.size++] = n;
            this.inSet[n] = true;
            return true;
        }
        return false;
    }

    public boolean contains(int n) {
        return this.inSet[n];
    }

    public int size() {
        return this.size;
    }

    public int maxIndex() {
        return this.indices.length - 1;
    }

    public void clear() {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            this.inSet[this.indices[i]] = false;
        }
        this.size = 0;
    }

    public int enumIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.indices[n];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("[ size=");
        stringBuilder.append(this.size);
        stringBuilder.append(" {");
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(this.enumIndex(i));
            if (i + 1 >= this.size) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("} ]");
        return stringBuilder.toString();
    }
}

