% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/web_fonts.R
\name{require_font}
\alias{require_font}
\title{Ensure font availability in a script}
\usage{
require_font(
  family,
  fallback = NULL,
  dir = tempdir(),
  repositories = c("Google Fonts", "Font Squirrel"),
  error = TRUE
)
}
\arguments{
\item{family}{The font family to require}

\item{fallback}{An available font to fall back to if \code{family} cannot be found
or downloaded}

\item{dir}{The location to put the font file downloaded from repositories}

\item{repositories}{The repositories to search for the font in case it is not
available on the system. They will be tried in the order given. Currently
only \code{"Google Fonts"} and \code{"Font Squirrel"} is available.}

\item{error}{Should the function throw an error if unsuccessful?}
}
\value{
Invisibly \code{TRUE} if the font is available or \code{FALSE} if not (this can
only be returned if \code{error = FALSE})
}
\description{
When running a script on a different machine you are not always in control of
which fonts are installed on the system and thus how graphics created by the
script ends up looking. \code{require_font()} is a way to specify your font
requirements for a script. It will look at the available fonts and if the
required font family is not present it will attempt to fetch it from one of
the given repositories (in the order given). If that fails, it will either
throw an error or, if \code{fallback} is given, provide an alias for the fallback
so it maps to the required font.
}
\examples{
# Should always work
require_font("sans")

}
